/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.scene.Element;

public class GridImage
extends Element {
    private int imageWidth;
    private int imageHeight;

    public GridImage(int w, int h) {
        this.imageWidth = w;
        this.imageHeight = h;
    }

    @Override
    public void draw() {
        float xspace = this.getWidth() / (float)this.imageWidth;
        float yspace = this.getHeight() / (float)this.imageHeight;
        float s = 1.0f;
        int minspace = 10;
        int jumpx = (int)(Math.max((float)minspace, xspace) / xspace);
        int jumpy = (int)(Math.max((float)minspace, yspace) / yspace);
        for (int x = 0; x <= this.imageWidth; x += jumpx) {
            Fill.crect((int)(this.getX() + xspace * (float)x - s), this.getY() - s, 2.0f, this.getHeight() + (float)(x == this.imageWidth ? 1 : 0));
        }
        for (int y = 0; y <= this.imageHeight; y += jumpy) {
            Fill.crect(this.getX() - s, (int)(this.getY() + (float)y * yspace - s), this.getWidth(), 2.0f);
        }
    }

    public void setImageSize(int w, int h) {
        this.imageWidth = w;
        this.imageHeight = h;
    }
}

