/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.collection.ObjectIntMap;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemType;
import java.text.NumberFormat;
import java.util.Locale;

public class ItemsDisplay
extends Table {
    private static final NumberFormat format = NumberFormat.getNumberInstance(Locale.getDefault());

    public ItemsDisplay() {
        this.rebuild();
    }

    public void rebuild() {
        this.clear();
        this.top().left();
        this.margin(0.0f);
        this.table(Tex.button, t -> {
            t.margin(10.0f).marginLeft(15.0f).marginTop(15.0f);
            t.add("$launcheditems").colspan(3).left().padBottom(5.0f);
            t.row();
            ObjectIntMap<Item> items = Vars.data.items();
            for (Item item : Vars.content.items()) {
                if (item.type != ItemType.material || !Vars.data.isUnlocked(item)) continue;
                t.label(() -> format.format(items.get(item, 0))).left();
                t.addImage(item.icon(Item.Icon.medium)).size(24.0f).padLeft(4.0f).padRight(4.0f);
                t.add(item.localizedName()).color(Color.lightGray).left();
                t.row();
            }
        });
    }
}

