/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.ClickListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Tex;

public class Minimap
extends Table {
    public Minimap() {
        this.background(Tex.pane);
        final float margin = 5.0f;
        this.touchable(Touchable.enabled);
        this.add(new Element(){
            {
                this.setSize(Scl.scl(140.0f));
            }

            @Override
            public void act(float delta) {
                this.setPosition(Scl.scl(margin), Scl.scl(margin));
                super.act(delta);
            }

            @Override
            public void draw() {
                if (Vars.renderer.minimap.getRegion() == null) {
                    return;
                }
                Draw.rect(Vars.renderer.minimap.getRegion(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
                if (Vars.renderer.minimap.getTexture() != null) {
                    Vars.renderer.minimap.drawEntities(this.x, this.y, this.width, this.height);
                }
            }
        }).size(140.0f);
        this.margin(margin);
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountx, float amounty) {
                Vars.renderer.minimap.zoomBy(amounty);
                return true;
            }
        });
        this.addListener(new ClickListener(){
            {
                this.tapSquareSize = Scl.scl(11.0f);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (this.inTapSquare()) {
                    super.touchUp(event, x, y, pointer, button);
                } else {
                    this.pressed = false;
                    this.pressedPointer = -1;
                    this.pressedButton = null;
                    this.cancelled = false;
                }
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (!this.inTapSquare(x, y)) {
                    this.invalidateTapSquare();
                }
                super.touchDragged(event, x, y, pointer);
                if (Vars.mobile) {
                    float max = (float)Math.min(Vars.world.width(), Vars.world.height()) / 16.0f / 2.0f;
                    Vars.renderer.minimap.setZoom(1.0f + y / Minimap.this.height * (max - 1.0f));
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Vars.ui.minimap.show();
            }
        });
        this.update(() -> {
            Element e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true);
            if (e != null && e.isDescendantOf(this)) {
                Core.scene.setScrollFocus(this);
            } else if (Core.scene.getScrollFocus() == this) {
                Core.scene.setScrollFocus(null);
            }
        });
    }
}

