/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.collection.FloatArray;
import io.anuke.arc.math.geom.Rectangle;

public class TreeLayout {
    public TreeLocation rootLocation = TreeLocation.top;
    public TreeAlignment alignment = TreeAlignment.awayFromRoot;
    public float gapBetweenLevels = 10.0f;
    public float gapBetweenNodes = 10.0f;
    private final FloatArray sizeOfLevel = new FloatArray();
    private float boundsLeft = Float.MAX_VALUE;
    private float boundsRight = Float.MIN_VALUE;
    private float boundsTop = Float.MAX_VALUE;
    private float boundsBottom = Float.MIN_VALUE;

    public void layout(TreeNode root) {
        this.firstWalk(root, null);
        this.calcSizeOfLevels(root, 0);
        this.secondWalk(root, -root.prelim, 0, 0.0f);
    }

    private float getWidthOrHeightOfNode(TreeNode treeNode, boolean returnWidth) {
        return returnWidth ? treeNode.width : treeNode.height;
    }

    private float getNodeThickness(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, !this.isLevelChangeInYAxis());
    }

    private float getNodeSize(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, this.isLevelChangeInYAxis());
    }

    private boolean isLevelChangeInYAxis() {
        return this.rootLocation == TreeLocation.top || this.rootLocation == TreeLocation.bottom;
    }

    private int getLevelChangeSign() {
        return this.rootLocation == TreeLocation.bottom || this.rootLocation == TreeLocation.right ? -1 : 1;
    }

    private void updateBounds(TreeNode node, float centerX, float centerY) {
        float width = node.width;
        float height = node.height;
        float left = centerX - width / 2.0f;
        float right = centerX + width / 2.0f;
        float top = centerY - height / 2.0f;
        float bottom = centerY + height / 2.0f;
        if (this.boundsLeft > left) {
            this.boundsLeft = left;
        }
        if (this.boundsRight < right) {
            this.boundsRight = right;
        }
        if (this.boundsTop > top) {
            this.boundsTop = top;
        }
        if (this.boundsBottom < bottom) {
            this.boundsBottom = bottom;
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.boundsLeft, this.boundsBottom, this.boundsRight - this.boundsLeft, this.boundsTop - this.boundsBottom);
    }

    private void calcSizeOfLevels(TreeNode node, int level) {
        float oldSize;
        if (this.sizeOfLevel.size <= level) {
            this.sizeOfLevel.add(0.0f);
            oldSize = 0.0f;
        } else {
            oldSize = this.sizeOfLevel.get(level);
        }
        float size = this.getNodeThickness(node);
        if (oldSize < size) {
            this.sizeOfLevel.set(level, size);
        }
        if (!node.isLeaf()) {
            for (Object child : node.children) {
                this.calcSizeOfLevels((TreeNode)child, level + 1);
            }
        }
    }

    public int getLevelCount() {
        return this.sizeOfLevel.size;
    }

    public float getGapBetweenNodes(TreeNode a, TreeNode b) {
        return this.gapBetweenNodes;
    }

    public float getSizeOfLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level must be >= 0");
        }
        if (level >= this.getLevelCount()) {
            throw new IllegalArgumentException("level must be < levelCount");
        }
        return this.sizeOfLevel.get(level);
    }

    private TreeNode getAncestor(TreeNode node) {
        return node.ancestor != null ? node.ancestor : node;
    }

    private float getDistance(TreeNode v, TreeNode w) {
        float sizeOfNodes = this.getNodeSize(v) + this.getNodeSize(w);
        return sizeOfNodes / 2.0f + this.getGapBetweenNodes(v, w);
    }

    private TreeNode nextLeft(TreeNode v) {
        return v.isLeaf() ? v.thread : v.children[0];
    }

    private TreeNode nextRight(TreeNode v) {
        return v.isLeaf() ? v.thread : v.children[v.children.length - 1];
    }

    private int getNumber(TreeNode node, TreeNode parentNode) {
        if (node.number == -1) {
            int number = 1;
            for (Object child : parentNode.children) {
                ((TreeNode)child).number = number++;
            }
        }
        return node.number;
    }

    private TreeNode ancestor(TreeNode vIMinus, TreeNode parentOfV, TreeNode defaultAncestor) {
        TreeNode ancestor = this.getAncestor(vIMinus);
        return ancestor.parent == parentOfV ? ancestor : defaultAncestor;
    }

    private void moveSubtree(TreeNode wMinus, TreeNode wPlus, TreeNode parent, float shift) {
        int subtrees = this.getNumber(wPlus, parent) - this.getNumber(wMinus, parent);
        wPlus.change = wPlus.change - shift / (float)subtrees;
        wPlus.shift = wPlus.shift + shift;
        wMinus.change = wMinus.change + shift / (float)subtrees;
        wPlus.prelim = wPlus.prelim + shift;
        wPlus.mode = wPlus.mode + shift;
    }

    private TreeNode apportion(TreeNode v, TreeNode defaultAncestor, TreeNode leftSibling, TreeNode parentOfV) {
        if (leftSibling == null) {
            return defaultAncestor;
        }
        TreeNode vOPlus = v;
        TreeNode vIPlus = v;
        TreeNode vIMinus = leftSibling;
        Object vOMinus = parentOfV.children[0];
        float sIPlus = vIPlus.mode;
        float sOPlus = vOPlus.mode;
        float sIMinus = vIMinus.mode;
        float sOMinus = ((TreeNode)vOMinus).mode;
        TreeNode nextRightVIMinus = this.nextRight(vIMinus);
        TreeNode nextLeftVIPlus = this.nextLeft(vIPlus);
        while (nextRightVIMinus != null && nextLeftVIPlus != null) {
            vIMinus = nextRightVIMinus;
            vIPlus = nextLeftVIPlus;
            vOMinus = this.nextLeft((TreeNode)vOMinus);
            vOPlus = this.nextRight(vOPlus);
            vOPlus.ancestor = v;
            float shift = vIMinus.prelim + sIMinus - (vIPlus.prelim + sIPlus) + this.getDistance(vIMinus, vIPlus);
            if (shift > 0.0f) {
                this.moveSubtree(this.ancestor(vIMinus, parentOfV, defaultAncestor), v, parentOfV, shift);
                sIPlus += shift;
                sOPlus += shift;
            }
            sIMinus += vIMinus.mode;
            sIPlus += vIPlus.mode;
            sOMinus += ((TreeNode)vOMinus).mode;
            sOPlus += vOPlus.mode;
            nextRightVIMinus = this.nextRight(vIMinus);
            nextLeftVIPlus = this.nextLeft(vIPlus);
        }
        if (nextRightVIMinus != null && this.nextRight(vOPlus) == null) {
            vOPlus.thread = nextRightVIMinus;
            TreeNode treeNode = vOPlus;
            treeNode.mode = treeNode.mode + (sIMinus - sOPlus);
        }
        if (nextLeftVIPlus != null && this.nextLeft((TreeNode)vOMinus) == null) {
            ((TreeNode)vOMinus).thread = nextLeftVIPlus;
            Object object = vOMinus;
            ((TreeNode)object).mode = ((TreeNode)object).mode + (sIPlus - sOMinus);
            defaultAncestor = v;
        }
        return defaultAncestor;
    }

    private void executeShifts(TreeNode v) {
        float shift = 0.0f;
        float change = 0.0f;
        for (int i = v.children.length - 1; i >= 0; --i) {
            Object w = v.children[i];
            change += ((TreeNode)w).change;
            Object t = w;
            ((TreeNode)t).prelim = ((TreeNode)t).prelim + shift;
            t = w;
            ((TreeNode)t).mode = ((TreeNode)t).mode + shift;
            shift += ((TreeNode)w).shift + change;
        }
    }

    private void firstWalk(TreeNode v, TreeNode leftSibling) {
        if (v.isLeaf()) {
            if (leftSibling != null) {
                v.prelim = leftSibling.prelim + this.getDistance(v, leftSibling);
            }
        } else {
            Object defaultAncestor = v.children[0];
            TreeNode previousChild = null;
            for (Object w : v.children) {
                this.firstWalk((TreeNode)w, previousChild);
                defaultAncestor = this.apportion((TreeNode)w, (TreeNode)defaultAncestor, previousChild, v);
                previousChild = (TreeNode)w;
            }
            this.executeShifts(v);
            float midpoint = (((TreeNode)v.children[0]).prelim + ((TreeNode)v.children[v.children.length - 1]).prelim) / 2.0f;
            if (leftSibling != null) {
                v.prelim = leftSibling.prelim + this.getDistance(v, leftSibling);
                v.mode = v.prelim - midpoint;
            } else {
                v.prelim = midpoint;
            }
        }
    }

    private void secondWalk(TreeNode v, float m, int level, float levelStart) {
        float levelChangeSign = this.getLevelChangeSign();
        boolean levelChangeOnYAxis = this.isLevelChangeInYAxis();
        float levelSize = this.getSizeOfLevel(level);
        float x = v.prelim + m;
        float y = this.alignment == TreeAlignment.center ? levelStart + levelChangeSign * (levelSize / 2.0f) : (this.alignment == TreeAlignment.towardsRoot ? levelStart + levelChangeSign * (this.getNodeThickness(v) / 2.0f) : levelStart + levelSize - levelChangeSign * (this.getNodeThickness(v) / 2.0f));
        if (!levelChangeOnYAxis) {
            float t = x;
            x = y;
            y = t;
        }
        v.x = x;
        v.y = y;
        this.updateBounds(v, x, y);
        if (!v.isLeaf()) {
            float nextLevelStart = levelStart + (levelSize + this.gapBetweenLevels) * levelChangeSign;
            for (Object w : v.children) {
                this.secondWalk((TreeNode)w, m + v.mode, level + 1, nextLevelStart);
            }
        }
    }

    public static class TreeNode<T extends TreeNode> {
        public float width;
        public float height;
        public float x;
        public float y;
        public T[] children;
        public T parent;
        private float mode;
        private float prelim;
        private float change;
        private float shift;
        private int number = -1;
        private TreeNode thread;
        private TreeNode ancestor;

        boolean isLeaf() {
            return this.children == null || this.children.length == 0;
        }
    }

    public static enum TreeAlignment {
        center,
        towardsRoot,
        awayFromRoot;

    }

    public static enum TreeLocation {
        top,
        left,
        bottom,
        right;

    }
}

