/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class AdminsDialog
extends FloatingDialog {
    public AdminsDialog() {
        super("$server.admins");
        this.addCloseButton();
        this.setup();
        this.shown(this::setup);
    }

    private void setup() {
        this.cont.clear();
        float w = 400.0f;
        float h = 80.0f;
        Table table = new Table();
        ScrollPane pane = new ScrollPane((Element)table);
        pane.setFadeScrollBars(false);
        if (Vars.netServer.admins.getAdmins().size == 0) {
            table.add("$server.admins.none");
        }
        for (Administration.PlayerInfo info : Vars.netServer.admins.getAdmins()) {
            Table res = new Table(Tex.button);
            res.margin(14.0f);
            res.labelWrap("[LIGHT_GRAY]" + info.lastName).width(w - h - 24.0f);
            res.add().growX();
            res.addImageButton(Icon.cancel, () -> Vars.ui.showConfirm("$confirm", "$confirmunadmin", () -> {
                Vars.netServer.admins.unAdminPlayer(info.id);
                Vars.playerGroup.all().each(player -> {
                    if (player != null && player.uuid != null && player.uuid.equals(info.id)) {
                        player.isAdmin = false;
                    }
                });
                this.setup();
            })).size(h).pad(-14.0f);
            table.add(res).width(w).height(h);
            table.row();
        }
        this.cont.add(pane);
    }
}

