/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.ui.Styles;

public class ColorPickDialog
extends Dialog {
    private Consumer<Color> cons;

    public ColorPickDialog() {
        super("");
        this.build();
    }

    private void build() {
        Table table = new Table();
        this.cont.add(table);
        for (int i = 0; i < Vars.playerColors.length; ++i) {
            Color color = Vars.playerColors[i];
            ImageButton button = table.addImageButton(Tex.whiteui, Styles.clearTogglei, 34.0f, () -> {
                this.cons.accept(color);
                this.hide();
            }).size(48.0f).get();
            button.setChecked(Vars.player.color.equals(color));
            button.getStyle().imageUpColor = color;
            if (i % 4 != 3) continue;
            table.row();
        }
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                this.hide();
            }
        });
    }

    public void show(Consumer<Color> cons) {
        this.cons = cons;
        this.show();
    }
}

