/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.function.BooleanConsumer;
import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.function.FloatConsumer;
import io.anuke.arc.function.FloatProvider;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.dialogs.LoadoutDialog;

public class CustomRulesDialog
extends FloatingDialog {
    private Table main;
    private Rules rules;
    private Supplier<Rules> resetter;
    private LoadoutDialog loadoutDialog = new LoadoutDialog();

    public CustomRulesDialog() {
        super("$mode.custom");
        this.setFillParent(true);
        this.shown(this::setup);
        this.addCloseButton();
    }

    public void show(Rules rules, Supplier<Rules> resetter) {
        this.rules = rules;
        this.resetter = resetter;
        this.show();
    }

    void setup() {
        this.cont.clear();
        this.cont.pane((Table m) -> {
            this.main = m;
        });
        this.main.margin(10.0f);
        this.main.addButton("$settings.reset", () -> {
            this.rules = this.resetter.get();
            this.setup();
        }).size(300.0f, 50.0f);
        this.main.left().defaults().fillX().left().pad(5.0f);
        this.main.row();
        this.title("$rules.title.waves");
        this.check("$rules.waves", b -> {
            this.rules.waves = b;
        }, () -> this.rules.waves);
        this.check("$rules.wavetimer", b -> {
            this.rules.waveTimer = b;
        }, () -> this.rules.waveTimer);
        this.check("$rules.waitForWaveToEnd", b -> {
            this.rules.waitForWaveToEnd = b;
        }, () -> this.rules.waitForWaveToEnd);
        this.number("$rules.wavespacing", false, f -> {
            this.rules.waveSpacing = f * 60.0f;
        }, () -> this.rules.waveSpacing / 60.0f, () -> true);
        this.number("$rules.dropzoneradius", false, f -> {
            this.rules.dropZoneRadius = f * 8.0f;
        }, () -> this.rules.dropZoneRadius / 8.0f, () -> true);
        this.title("$rules.title.respawns");
        this.number("$rules.respawntime", f -> {
            this.rules.respawnTime = f * 60.0f;
        }, () -> this.rules.respawnTime / 60.0f);
        this.title("$rules.title.resourcesbuilding");
        this.check("$rules.infiniteresources", b -> {
            this.rules.infiniteResources = b;
        }, () -> this.rules.infiniteResources);
        this.number("$rules.buildcostmultiplier", false, f -> {
            this.rules.buildCostMultiplier = f;
        }, () -> this.rules.buildCostMultiplier, () -> !this.rules.infiniteResources);
        this.number("$rules.buildspeedmultiplier", f -> {
            this.rules.buildSpeedMultiplier = f;
        }, () -> this.rules.buildSpeedMultiplier);
        this.main.addButton("$configure", () -> this.loadoutDialog.show(Blocks.coreShard.itemCapacity, () -> this.rules.loadout, () -> {
            this.rules.loadout.clear();
            this.rules.loadout.add(new ItemStack(Items.copper, 100));
        }, () -> {}, () -> {}, item -> item.type == ItemType.material)).left().width(300.0f);
        this.main.row();
        this.title("$rules.title.player");
        this.number("$rules.playerdamagemultiplier", f -> {
            this.rules.playerDamageMultiplier = f;
        }, () -> this.rules.playerDamageMultiplier);
        this.number("$rules.playerhealthmultiplier", f -> {
            this.rules.playerHealthMultiplier = f;
        }, () -> this.rules.playerHealthMultiplier);
        this.title("$rules.title.unit");
        this.check("$rules.unitdrops", b -> {
            this.rules.unitDrops = b;
        }, () -> this.rules.unitDrops, () -> true);
        this.number("$rules.unitbuildspeedmultiplier", f -> {
            this.rules.unitBuildSpeedMultiplier = f;
        }, () -> this.rules.unitBuildSpeedMultiplier);
        this.number("$rules.unithealthmultiplier", f -> {
            this.rules.unitHealthMultiplier = f;
        }, () -> this.rules.unitHealthMultiplier);
        this.number("$rules.unitdamagemultiplier", f -> {
            this.rules.unitDamageMultiplier = f;
        }, () -> this.rules.unitDamageMultiplier);
        this.title("$rules.title.enemy");
        this.check("$rules.attack", b -> {
            this.rules.attackMode = b;
        }, () -> this.rules.attackMode);
        this.check("$rules.enemyCheat", b -> {
            this.rules.enemyCheat = b;
        }, () -> this.rules.enemyCheat);
        this.number("$rules.enemycorebuildradius", f -> {
            this.rules.enemyCoreBuildRadius = f * 8.0f;
        }, () -> Math.min(this.rules.enemyCoreBuildRadius / 8.0f, 200.0f));
    }

    void number(String text, FloatConsumer cons, FloatProvider prov) {
        this.number(text, false, cons, prov, () -> true);
    }

    void number(String text, boolean integer, FloatConsumer cons, FloatProvider prov, BooleanProvider condition) {
        this.main.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f).update((T a) -> a.setColor(condition.get() ? Color.white : Color.gray));
            Vars.platform.addDialog(t.addField((integer ? (float)((int)prov.get()) : prov.get()) + "", s -> cons.accept(Strings.parseFloat(s))).padRight(100.0f).update((T a) -> a.setDisabled(!condition.get())).valid(Strings::canParsePositiveFloat).width(120.0f).left().get());
        }).padTop(0.0f);
        this.main.row();
    }

    void check(String text, BooleanConsumer cons, BooleanProvider prov) {
        this.check(text, cons, prov, () -> true);
    }

    void check(String text, BooleanConsumer cons, BooleanProvider prov, BooleanProvider condition) {
        this.main.addCheck(text, cons).checked(prov.get()).update((T a) -> a.setDisabled(!condition.get())).padRight(100.0f).get().left();
        this.main.row();
    }

    void title(String text) {
        this.main.add(text).color(Pal.accent).padTop(20.0f).padBottom(20.0f).padRight(100.0f);
        this.main.row();
    }
}

