/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.ClickListener;
import io.anuke.arc.scene.event.HandCursorListener;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.Tooltip;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.Content;
import io.anuke.mindustry.game.UnlockableContent;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class DatabaseDialog
extends FloatingDialog {
    public DatabaseDialog() {
        super("$database");
        this.shouldPause = true;
        this.addCloseButton();
        this.shown(this::rebuild);
        this.onResize(this::rebuild);
    }

    void rebuild() {
        this.cont.clear();
        Table table = new Table();
        table.margin(20.0f);
        ScrollPane pane = new ScrollPane((Element)table);
        Array<Content>[] allContent = Vars.content.getContentMap();
        for (int j = 0; j < allContent.length; ++j) {
            ContentType type = ContentType.values()[j];
            Array<Content> array = allContent[j].select(c -> c instanceof UnlockableContent && !((UnlockableContent)c).isHidden());
            if (array.size == 0) continue;
            table.add("$content." + type.name() + ".name").growX().left().color(Pal.accent);
            table.row();
            table.addImage().growX().pad(5.0f).padLeft(0.0f).padRight(0.0f).height(3.0f).color(Pal.accent);
            table.row();
            table.table((Table list) -> {
                list.left();
                int maxWidth = Core.graphics.isPortrait() ? 7 : 13;
                int count = 0;
                for (int i = 0; i < array.size; ++i) {
                    UnlockableContent unlock = (UnlockableContent)array.get(i);
                    Image image = this.unlocked(unlock) ? new Image(unlock.getContentIcon()) : new Image((Drawable)Icon.lockedSmall, Pal.gray);
                    list.add(image).size(32.0f).pad(3.0f);
                    ClickListener listener = new ClickListener();
                    image.addListener(listener);
                    if (!Vars.mobile && this.unlocked(unlock)) {
                        image.addListener(new HandCursorListener());
                        image.update(() -> image.getColor().lerp(!listener.isOver() ? Color.lightGray : Color.white, 0.4f * Time.delta()));
                    }
                    if (this.unlocked(unlock)) {
                        image.clicked(() -> Vars.ui.content.show(unlock));
                        image.addListener(new Tooltip(t -> t.background(Tex.button).add(unlock.localizedName())));
                    }
                    if (++count % maxWidth != 0) continue;
                    list.row();
                }
            }).growX().left().padBottom(10.0f);
            table.row();
        }
        this.cont.add(pane);
    }

    boolean unlocked(UnlockableContent content) {
        return !Vars.world.isZone() && !Vars.state.is(GameState.State.menu) || content.unlocked();
    }
}

