/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Stack;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.scene.utils.Elements;
import io.anuke.arc.util.Scaling;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Zones;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.Saves;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.io.SaveIO;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.ui.ItemsDisplay;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.TreeLayout;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.dialogs.ZoneInfoDialog;

public class DeployDialog
extends FloatingDialog {
    private final float nodeSize = Scl.scl(230.0f);
    private ObjectSet<ZoneNode> nodes = new ObjectSet();
    private ZoneInfoDialog info = new ZoneInfoDialog();
    private Rectangle bounds = new Rectangle();
    static float panX = 0.0f;
    static float panY = -200.0f;

    public DeployDialog() {
        super("", Styles.fullDialog);
        ZoneNode root = new ZoneNode(Zones.groundZero, null);
        TreeLayout layout = new TreeLayout();
        layout.gapBetweenLevels = layout.gapBetweenNodes = Scl.scl(60.0f);
        layout.gapBetweenNodes = Scl.scl(120.0f);
        layout.layout(root);
        this.bounds.set(layout.getBounds());
        this.bounds.y += this.nodeSize * 0.4f;
        this.addCloseButton();
        this.buttons.addImageTextButton("$techtree", Icon.tree, () -> Vars.ui.tech.show()).size(230.0f, 64.0f);
        this.shown(this::setup);
    }

    public void setup() {
        Vars.platform.updateRPC();
        this.cont.clear();
        this.titleTable.remove();
        this.margin(0.0f).marginBottom(8.0f);
        Stack stack = new Stack();
        stack.add(new Image(new Texture("sprites/backgrounds/stars.png"){
            {
                this.setFilter(Texture.TextureFilter.Linear);
            }
        }).setScaling(Scaling.fill));
        stack.add(new Image(new Texture("sprites/backgrounds/planet-zero.png"){
            {
                this.setFilter(Texture.TextureFilter.Linear);
            }
        }){
            {
                float[] time = new float[]{0.0f};
                this.setColor(Color.fromGray(0.3f));
                this.setScale(1.5f);
                this.update(() -> {
                    this.setOrigin(1);
                    time[0] = time[0] + Core.graphics.getDeltaTime() * 10.0f;
                    this.setTranslation(Mathf.sin(time[0], 60.0f, 70.0f) + panX / 30.0f, Mathf.cos(time[0], 140.0f, 80.0f) + (panY + 200.0f) / 30.0f);
                });
            }
        }.setScaling(Scaling.fit));
        if (Vars.control.saves.getZoneSlot() != null) {
            float size = 250.0f;
            stack.add(new Table(t -> {
                Saves.SaveSlot slot = Vars.control.saves.getZoneSlot();
                Stack sub = new Stack();
                if (slot.getZone() != null) {
                    sub.add(new Table(f -> f.margin(4.0f).add(new Image()).color(Color.fromGray(0.1f)).grow()));
                    sub.add(new Table(f -> f.margin(4.0f).add(new Image(slot.getZone().preview).setScaling(Scaling.fit)).update((T img) -> {
                        TextureRegionDrawable draw = (TextureRegionDrawable)img.getDrawable();
                        if (draw.getRegion().getTexture().isDisposed()) {
                            draw.setRegion(slot.getZone().preview);
                        }
                        Texture text = slot.previewTexture();
                        if (draw.getRegion() == slot.getZone().preview && text != null) {
                            draw.setRegion(new TextureRegion(text));
                        }
                    }).color(Color.darkGray).grow()));
                }
                TextButton button = Elements.newButton(Core.bundle.format("resume", slot.getZone().localizedName()), Styles.squaret, () -> {
                    this.hide();
                    Vars.ui.loadAnd(() -> {
                        Vars.logic.reset();
                        Vars.net.reset();
                        try {
                            Vars.control.saves.getZoneSlot().load();
                            Vars.state.set(GameState.State.playing);
                        }
                        catch (SaveIO.SaveException e) {
                            e.printStackTrace();
                            if (Vars.control.saves.getZoneSlot() != null) {
                                Vars.control.saves.getZoneSlot().delete();
                            }
                            Core.app.post(() -> Vars.ui.showInfo("$save.corrupted"));
                            this.show();
                        }
                    });
                });
                sub.add(button);
                t.add(sub).size(size);
                String color = "[lightgray]";
                button.defaults().colspan(2);
                button.row();
                button.add(Core.bundle.format("save.wave", color + slot.getWave()));
                button.row();
                button.label(() -> Core.bundle.format("save.playtime", color + slot.getPlayTime()));
                button.row();
                t.row();
                t.addButton("$abandon", () -> Vars.ui.showConfirm("$warning", "$abandon.text", () -> {
                    slot.delete();
                    this.setup();
                })).width(size).height(50.0f).padTop(3.0f);
            }));
        } else {
            stack.add(new View());
        }
        stack.add(new ItemsDisplay());
        this.cont.add(stack).grow();
        for (ZoneNode node : this.nodes) {
            node.allChildren.clear();
            node.allChildren.addAll((ZoneNode[])node.children);
            for (ZoneNode other : new ObjectSet.ObjectSetIterator<ZoneNode>(this.nodes)) {
                if (!Structs.contains(other.zone.zoneRequirements, req -> req.zone == node.zone)) continue;
                node.allChildren.add(other);
            }
        }
    }

    boolean hidden(Zone zone) {
        for (Zone.ZoneRequirement other : zone.zoneRequirements) {
            if (Vars.data.isUnlocked(other.zone)) continue;
            return true;
        }
        return false;
    }

    void buildButton(Zone zone, Button button) {
        button.setDisabled(() -> this.hidden(zone));
        button.clicked(() -> this.info.show(zone));
        if (zone.unlocked() && !this.hidden(zone)) {
            button.labelWrap(zone.localizedName()).style(Styles.outlineLabel).width(140.0f).growX().get().setAlignment(1);
        } else {
            Consumer<Element> flasher = zone.canUnlock() && !this.hidden(zone) ? e -> e.update(() -> e.getColor().set(Color.white).lerp(Pal.accent, Mathf.absin(3.0f, 1.0f))) : e -> {};
            flasher.accept(button.addImage(Icon.locked).get());
            button.row();
            flasher.accept(button.add("$locked").get());
        }
    }

    class ZoneNode
    extends TreeLayout.TreeNode<ZoneNode> {
        final Array<Zone> arr = new Array();
        final Array<ZoneNode> allChildren = new Array();
        final Zone zone;

        ZoneNode(Zone zone, ZoneNode parent) {
            this.zone = zone;
            this.parent = parent;
            this.width = this.height = DeployDialog.this.nodeSize;
            DeployDialog.this.nodes.add(this);
            this.arr.selectFrom(Vars.content.zones(), other -> other.zoneRequirements.length > 0 && other.zoneRequirements[0].zone == zone);
            this.children = new ZoneNode[this.arr.size];
            for (int i = 0; i < ((ZoneNode[])this.children).length; ++i) {
                ((ZoneNode[])this.children)[i] = new ZoneNode(this.arr.get(i), this);
            }
        }
    }

    class View
    extends Group {
        View() {
            for (ZoneNode node : DeployDialog.this.nodes) {
                Stack stack = new Stack();
                Tmp.v1.set(node.width, node.height);
                if (node.zone.preview != null) {
                    Tmp.v1.set(Scaling.fit.apply(node.zone.preview.getWidth(), node.zone.preview.getHeight(), node.width, node.height));
                }
                stack.setSize(Tmp.v1.x, Tmp.v1.y);
                stack.add(new Table(t -> t.margin(4.0f).add(new Image(node.zone.preview).setScaling(Scaling.stretch)).color(node.zone.unlocked() ? Color.darkGray : Color.fromGray(0.2f)).grow()));
                stack.update(() -> stack.setPosition(node.x + panX + this.width / 2.0f, node.y + panY + this.height / 2.0f, 1));
                Button button = new Button(Styles.squaret);
                DeployDialog.this.buildButton(node.zone, button);
                stack.add(button);
                this.addChild(stack);
            }
            this.dragged((x, y) -> {
                panX += x;
                panY += y;
                this.clamp();
            });
        }

        void clamp() {
            float pad = DeployDialog.this.nodeSize;
            float ox = this.width / 2.0f;
            float oy = this.height / 2.0f;
            float rx = ((DeployDialog)DeployDialog.this).bounds.x + panX + ox;
            float ry = panY + oy + ((DeployDialog)DeployDialog.this).bounds.y;
            float rw = ((DeployDialog)DeployDialog.this).bounds.width;
            float rh = ((DeployDialog)DeployDialog.this).bounds.height;
            rx = Mathf.clamp(rx, -rw + pad, (float)Core.graphics.getWidth() - pad);
            ry = Mathf.clamp(ry, pad, (float)Core.graphics.getHeight() - rh - pad);
            panX = rx - ((DeployDialog)DeployDialog.this).bounds.x - ox;
            panY = ry - ((DeployDialog)DeployDialog.this).bounds.y - oy;
        }

        @Override
        public void draw() {
            this.clamp();
            float offsetX = panX + this.width / 2.0f + this.x;
            float offsetY = panY + this.height / 2.0f + this.y;
            for (ZoneNode node : DeployDialog.this.nodes) {
                for (ZoneNode child : node.allChildren) {
                    Lines.stroke(Scl.scl(4.0f), node.zone.locked() || child.zone.locked() ? Pal.gray : Pal.gray);
                    Draw.alpha(this.parentAlpha);
                    Lines.line(node.x + offsetX, node.y + offsetY, child.x + offsetX, child.y + offsetY);
                }
            }
            Draw.reset();
            super.draw();
        }
    }
}

