/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;

public class FloatingDialog
extends Dialog {
    private boolean wasPaused;
    protected boolean shouldPause;

    public FloatingDialog(String title, Dialog.DialogStyle style) {
        super(title, style);
        this.setFillParent(true);
        this.title.setAlignment(1);
        this.titleTable.row();
        this.titleTable.addImage(Tex.whiteui, Pal.accent).growX().height(3.0f).pad(4.0f);
        this.hidden(() -> {
            if (this.shouldPause && !Vars.state.is(GameState.State.menu) && (!this.wasPaused || Vars.net.active())) {
                Vars.state.set(GameState.State.playing);
            }
            Sounds.back.play();
        });
        this.shown(() -> {
            if (this.shouldPause && !Vars.state.is(GameState.State.menu)) {
                this.wasPaused = Vars.state.is(GameState.State.paused);
                Vars.state.set(GameState.State.paused);
            }
        });
    }

    public FloatingDialog(String title) {
        this(title, Core.scene.getStyle(Dialog.DialogStyle.class));
    }

    protected void onResize(Runnable run) {
        Events.on(EventType.ResizeEvent.class, event -> {
            if (this.isShown() && Core.scene.getDialog() == this) {
                run.run();
                this.updateScrollFocus();
            }
        });
    }

    @Override
    public void addCloseButton() {
        this.buttons.addImageTextButton("$back", Icon.arrowLeft, this::hide).size(210.0f, 64.0f);
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                Core.app.post(this::hide);
            }
        });
    }
}

