/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Stats;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class GameOverDialog
extends FloatingDialog {
    private Team winner;

    public GameOverDialog() {
        super("$gameover");
        this.setFillParent(true);
        this.shown(this::rebuild);
    }

    public void show(Team winner) {
        this.winner = winner;
        this.show();
        if (winner == Vars.player.getTeam()) {
            Events.fire(new EventType.WinEvent());
        } else {
            Events.fire(new EventType.LoseEvent());
        }
    }

    void rebuild() {
        this.title.setText(Vars.state.launched ? "$launch.title" : "$gameover");
        this.buttons.clear();
        this.cont.clear();
        this.buttons.margin(10.0f);
        if (Vars.state.rules.pvp) {
            this.cont.add(Core.bundle.format("gameover.pvp", this.winner.localized())).pad(6.0f);
            this.buttons.addButton("$menu", () -> {
                this.hide();
                Vars.state.set(GameState.State.menu);
                Vars.logic.reset();
            }).size(130.0f, 60.0f);
        } else {
            if (Vars.control.isHighScore()) {
                this.cont.add("$highscore").pad(6.0f);
                this.cont.row();
            }
            this.cont.pane((Table t) -> {
                t.margin(13.0f);
                t.left().defaults().left();
                t.add(Core.bundle.format("stat.wave", Vars.state.stats.wavesLasted));
                t.row();
                t.add(Core.bundle.format("stat.enemiesDestroyed", Vars.state.stats.enemyUnitsDestroyed));
                t.row();
                t.add(Core.bundle.format("stat.built", Vars.state.stats.buildingsBuilt));
                t.row();
                t.add(Core.bundle.format("stat.destroyed", Vars.state.stats.buildingsDestroyed));
                t.row();
                t.add(Core.bundle.format("stat.deconstructed", Vars.state.stats.buildingsDeconstructed));
                t.row();
                if (Vars.world.isZone() && !Vars.state.stats.itemsDelivered.isEmpty()) {
                    t.add("$stat.delivered");
                    t.row();
                    for (Item item : Vars.content.items()) {
                        if (Vars.state.stats.itemsDelivered.get(item, 0) <= 0) continue;
                        t.table((Table items) -> {
                            items.add("    [LIGHT_GRAY]" + Vars.state.stats.itemsDelivered.get(item, 0));
                            items.addImage(item.icon(Item.Icon.medium)).size(24.0f).pad(4.0f);
                        }).left();
                        t.row();
                    }
                }
                if (Vars.world.isZone()) {
                    Stats.RankResult result = Vars.state.stats.calculateRank(Vars.world.getZone(), Vars.state.launched);
                    t.add(Core.bundle.format("stat.rank", (Object)((Object)result.rank) + result.modifier));
                    t.row();
                }
            }).pad(12.0f);
            if (Vars.world.isZone()) {
                this.buttons.addButton("$continue", () -> {
                    this.hide();
                    Vars.state.set(GameState.State.menu);
                    Vars.logic.reset();
                    Vars.ui.deploy.show();
                }).size(130.0f, 60.0f);
            } else {
                this.buttons.addButton("$menu", () -> {
                    this.hide();
                    Vars.state.set(GameState.State.menu);
                    Vars.logic.reset();
                }).size(130.0f, 60.0f);
            }
        }
    }
}

