/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.ColorPickDialog;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import java.io.IOException;

public class HostDialog
extends FloatingDialog {
    float w = 300.0f;

    public HostDialog() {
        super("$hostserver");
        this.addCloseButton();
        this.cont.table((Table t) -> {
            t.add("$name").padRight(10.0f);
            t.addField(Core.settings.getString("name"), text -> {
                Vars.player.name = text;
                Core.settings.put("name", text);
                Core.settings.save();
                Vars.ui.listfrag.rebuild();
            }).grow().pad(8.0f).get().setMaxLength(40);
            ImageButton button = t.addImageButton(Tex.whiteui, Styles.clearFulli, 40.0f, () -> new ColorPickDialog().show((Color color) -> {
                Vars.player.color.set((Color)color);
                Core.settings.put("color-0", Color.rgba8888(color));
                Core.settings.save();
            })).size(54.0f).get();
            button.update(() -> {
                button.getStyle().imageUpColor = Vars.player.color;
            });
        }).width(this.w).height(70.0f).pad(4.0f).colspan(3);
        this.cont.row();
        this.cont.add().width(65.0f);
        this.cont.addButton("$host", () -> {
            if (Core.settings.getString("name").trim().isEmpty()) {
                Vars.ui.showInfo("$noname");
                return;
            }
            this.runHost();
        }).width(this.w).height(70.0f);
        this.cont.addButton("?", () -> Vars.ui.showInfo("$host.info")).size(65.0f, 70.0f).padLeft(6.0f);
        this.shown(() -> {
            if (!Vars.steam) {
                Core.app.post(() -> Core.settings.getBoolOnce("hostinfo", () -> Vars.ui.showInfo("$host.info")));
            }
        });
    }

    public void runHost() {
        Vars.ui.loadfrag.show("$hosting");
        Time.runTask(5.0f, () -> {
            try {
                Vars.net.host(6567);
                Vars.player.isAdmin = true;
            }
            catch (IOException e) {
                Vars.ui.showException("$server.error", e);
            }
            Vars.ui.loadfrag.hide();
            this.hide();
        });
    }
}

