/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Cell;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Version;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.net.Host;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.ColorPickDialog;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class JoinDialog
extends FloatingDialog {
    Array<Server> servers = new Array();
    Dialog add;
    Server renaming;
    Table local = new Table();
    Table remote = new Table();
    Table hosts = new Table();
    int totalHosts;

    public JoinDialog() {
        super("$joingame");
        this.loadServers();
        this.buttons.add().width(60.0f);
        this.buttons.add().growX();
        this.addCloseButton();
        this.buttons.add().growX();
        this.buttons.addButton("?", () -> Vars.ui.showInfo("$join.info")).size(60.0f, 64.0f);
        this.add = new FloatingDialog("$joingame.title");
        this.add.cont.add("$joingame.ip").padRight(5.0f).left();
        TextField field = this.add.cont.addField(Core.settings.getString("ip"), text -> {
            Core.settings.put("ip", text);
            Core.settings.save();
        }).size(320.0f, 54.0f).get();
        Vars.platform.addDialog(field, 100);
        this.add.cont.row();
        this.add.buttons.defaults().size(140.0f, 60.0f).pad(4.0f);
        this.add.buttons.addButton("$cancel", this.add::hide);
        this.add.buttons.addButton("$ok", () -> {
            if (this.renaming == null) {
                Server server = new Server();
                server.setIP(Core.settings.getString("ip"));
                this.servers.add(server);
                this.saveServers();
                this.setupRemote();
                this.refreshRemote();
            } else {
                this.renaming.setIP(Core.settings.getString("ip"));
                this.saveServers();
                this.setupRemote();
                this.refreshRemote();
            }
            this.add.hide();
        }).disabled(b -> Core.settings.getString("ip").isEmpty() || Vars.net.active());
        this.add.shown(() -> {
            this.add.title.setText(this.renaming != null ? "$server.edit" : "$server.add");
            if (this.renaming != null) {
                field.setText(this.renaming.displayIP());
            }
        });
        this.keyDown(KeyCode.F5, () -> {
            this.refreshLocal();
            this.refreshRemote();
        });
        this.shown(() -> {
            this.setup();
            this.refreshLocal();
            this.refreshRemote();
            Core.app.post(() -> Core.settings.getBoolOnce("joininfo", () -> Vars.ui.showInfo("$join.info")));
        });
        this.onResize(this::setup);
    }

    void setupRemote() {
        this.remote.clear();
        for (Server server : this.servers) {
            TextButton[] buttons = new TextButton[]{null};
            TextButton button = buttons[0] = this.remote.addButton("[accent]" + server.displayIP(), Styles.cleart, () -> {
                if (!buttons[0].childrenPressed()) {
                    if (server.lastHost != null && server.lastHost.version != Version.build && Version.build != -1 && server.lastHost.version != -1) {
                        Vars.ui.showInfo("[scarlet]" + (server.lastHost.version > Version.build ? Packets.KickReason.clientOutdated : Packets.KickReason.serverOutdated).toString() + "\n[]" + Core.bundle.format("server.versions", Version.build, server.lastHost.version));
                    } else {
                        this.connect(server.ip, server.port);
                    }
                }
            }).width(this.targetWidth()).pad(4.0f).get();
            button.getLabel().setWrap(true);
            Table inner = new Table();
            button.clearChildren();
            button.add(inner).growX();
            inner.add(button.getLabel()).growX();
            inner.addImageButton((Drawable)Icon.arrowUpSmall, Styles.emptyi, () -> {
                int index = this.servers.indexOf(server);
                if (index > 0) {
                    this.servers.remove(index);
                    this.servers.insert(0, server);
                    this.saveServers();
                    this.setupRemote();
                    for (Server other : this.servers) {
                        if (other.lastHost != null) {
                            this.setupServer(other, other.lastHost);
                            continue;
                        }
                        this.refreshServer(other);
                    }
                }
            }).margin(3.0f).padTop(6.0f).top().right();
            inner.addImageButton((Drawable)Icon.loadingSmall, Styles.emptyi, () -> this.refreshServer(server)).margin(3.0f).padTop(6.0f).top().right();
            inner.addImageButton((Drawable)Icon.pencilSmall, Styles.emptyi, () -> {
                this.renaming = server;
                this.add.show();
            }).margin(3.0f).padTop(6.0f).top().right();
            inner.addImageButton((Drawable)Icon.trash16Small, Styles.emptyi, () -> Vars.ui.showConfirm("$confirm", "$server.delete", () -> {
                this.servers.removeValue(server, true);
                this.saveServers();
                this.setupRemote();
                this.refreshRemote();
            })).margin(3.0f).pad(6.0f).top().right();
            button.row();
            server.content = button.table((Table t) -> {}).grow().get();
            this.remote.row();
        }
    }

    void refreshRemote() {
        for (Server server : this.servers) {
            this.refreshServer(server);
        }
    }

    void refreshServer(Server server) {
        server.content.clear();
        server.content.label(() -> Core.bundle.get("server.refreshing") + Strings.animated(Time.time(), 4, 11.0f, "."));
        Vars.net.pingHost(server.ip, server.port, host -> this.setupServer(server, (Host)host), e -> {
            server.content.clear();
            server.content.add("$host.invalid");
        });
    }

    void setupServer(Server server, Host host) {
        server.lastHost = host;
        server.content.clear();
        this.buildServer(host, server.content);
    }

    void buildServer(Host host, Table content) {
        String versionString = host.version == -1 ? Core.bundle.format("server.version", Core.bundle.get("server.custombuild"), "") : (host.version == 0 ? Core.bundle.get("server.outdated") : (host.version < Version.build && Version.build != -1 ? Core.bundle.get("server.outdated") + "\n" + Core.bundle.format("server.version", host.version, "") : (host.version > Version.build && Version.build != -1 ? Core.bundle.get("server.outdated.client") + "\n" + Core.bundle.format("server.version", host.version, "") : Core.bundle.format("server.version", host.version, host.versionType))));
        content.table((Table t) -> {
            t.add("[lightgray]" + host.name + "   " + versionString).width(this.targetWidth() - 10.0f).left().get().setEllipsis(true);
            t.row();
            t.add("[lightgray]" + Core.bundle.format("players" + (host.players == 1 && host.playerLimit <= 0 ? ".single" : ""), (host.players == 0 ? "[lightgray]" : "[accent]") + host.players + (host.playerLimit > 0 ? "[lightgray]/[accent]" + host.playerLimit : "") + "[lightgray]")).left();
            t.row();
            t.add("[lightgray]" + Core.bundle.format("save.map", host.mapname) + "[lightgray] / " + host.mode.toString()).width(this.targetWidth() - 10.0f).left().get().setEllipsis(true);
        }).expand().left().bottom().padLeft(12.0f).padBottom(8.0f);
    }

    void setup() {
        float w = this.targetWidth();
        this.hosts.clear();
        this.hosts.add(this.remote).growX();
        this.hosts.row();
        this.hosts.add(this.local).width(w);
        ScrollPane pane = new ScrollPane((Element)this.hosts);
        pane.setFadeScrollBars(false);
        pane.setScrollingDisabled(true, false);
        this.setupRemote();
        this.refreshRemote();
        this.cont.clear();
        this.cont.table((Table t) -> {
            t.add("$name").padRight(10.0f);
            if (!Vars.steam) {
                t.addField(Core.settings.getString("name"), text -> {
                    Vars.player.name = text;
                    Core.settings.put("name", text);
                    Core.settings.save();
                }).grow().pad(8.0f).get().setMaxLength(40);
            } else {
                t.add(Vars.player.name).update((T l) -> l.setColor(Vars.player.color)).grow().pad(8.0f);
            }
            ImageButton button = t.addImageButton(Tex.whiteui, Styles.clearFulli, 40.0f, () -> new ColorPickDialog().show((Color color) -> {
                Vars.player.color.set((Color)color);
                Core.settings.put("color-0", Color.rgba8888(color));
                Core.settings.save();
            })).size(54.0f).get();
            button.update(() -> {
                button.getStyle().imageUpColor = Vars.player.color;
            });
        }).width(w).height(70.0f).pad(4.0f);
        this.cont.row();
        this.cont.add(pane).width(w + 38.0f).pad(0.0f);
        this.cont.row();
        this.cont.addCenteredImageTextButton("$server.add", Icon.add, () -> {
            this.renaming = null;
            this.add.show();
        }).marginLeft(6.0f).width(w).height(80.0f).update((T button) -> {
            Cell cell;
            float pw = w;
            float pad = 0.0f;
            if (((Element)pane.getChildren().first()).getPrefHeight() > pane.getHeight()) {
                pw = w + 30.0f;
                pad = 6.0f;
            }
            if (!Mathf.isEqual((cell = ((Table)pane.getParent()).getCell(button)).minWidth(), pw)) {
                cell.width(pw);
                cell.padLeft(pad);
                pane.getParent().invalidateHierarchy();
            }
        });
    }

    void refreshLocal() {
        this.totalHosts = 0;
        this.local.clear();
        this.local.background(null);
        this.local.table(Tex.button, t -> t.label(() -> "[accent]" + Core.bundle.get("hosts.discovering.any") + Strings.animated(Time.time(), 4, 10.0f, ".")).pad(10.0f)).growX();
        Vars.net.discoverServers(this::addLocalHost, this::finishLocalHosts);
        for (String host : Vars.defaultServers) {
            Vars.net.pingHost(host, 6567, this::addLocalHost, e -> {});
        }
    }

    void finishLocalHosts() {
        if (this.totalHosts == 0) {
            this.local.clear();
            this.local.background(Tex.button);
            this.local.add("$hosts.none").pad(10.0f);
            this.local.add().growX();
            this.local.addImageButton(Icon.loading, this::refreshLocal).pad(-12.0f).padLeft(0.0f).size(70.0f);
        } else {
            this.local.background(null);
        }
    }

    void addLocalHost(Host host) {
        if (this.totalHosts == 0) {
            this.local.clear();
        }
        this.local.background(null);
        ++this.totalHosts;
        float w = this.targetWidth();
        this.local.row();
        TextButton button = this.local.addButton("", Styles.cleart, () -> this.connect(host.address, 6567)).width(w).pad(5.0f).get();
        button.clearChildren();
        this.buildServer(host, button);
    }

    public void connect(String ip, int port) {
        if (Vars.player.name.trim().isEmpty()) {
            Vars.ui.showInfo("$noname");
            return;
        }
        Vars.ui.loadfrag.show("$connecting");
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            Vars.netClient.disconnectQuietly();
        });
        Time.runTask(2.0f, () -> {
            Vars.logic.reset();
            Vars.net.reset();
            Vars.netClient.beginConnecting();
            Vars.net.connect(ip, port, () -> {
                this.hide();
                this.add.hide();
            });
        });
    }

    float targetWidth() {
        return Core.graphics.isPortrait() ? 350.0f : 500.0f;
    }

    private void loadServers() {
        this.servers = Core.settings.getObject("server-list", Array.class, Array::new);
    }

    private void saveServers() {
        Core.settings.putObject("server-list", this.servers);
        Core.settings.save();
    }

    public static class Server {
        public String ip;
        public int port;
        transient Table content;
        transient Host lastHost;

        void setIP(String ip) {
            if (ip.lastIndexOf(58) != -1 && ip.lastIndexOf(58) != ip.length() - 1) {
                try {
                    int idx = ip.lastIndexOf(58);
                    this.ip = ip.substring(0, idx);
                    this.port = Integer.parseInt(ip.substring(idx + 1));
                }
                catch (Exception e) {
                    this.ip = ip;
                    this.port = 6567;
                }
            } else {
                this.ip = ip;
                this.port = 6567;
            }
        }

        String displayIP() {
            return this.ip + (this.port != 6567 ? ":" + this.port : "");
        }
    }
}

