/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import java.util.Locale;

public class LanguageDialog
extends FloatingDialog {
    private Locale lastLocale;

    public LanguageDialog() {
        super("$settings.language");
        this.addCloseButton();
        this.setup();
    }

    private void setup() {
        Table langs = new Table();
        langs.marginRight(24.0f).marginLeft(24.0f);
        ScrollPane pane = new ScrollPane((Element)langs);
        pane.setFadeScrollBars(false);
        ButtonGroup group = new ButtonGroup();
        for (Locale loc : Vars.locales) {
            TextButton button = new TextButton(Strings.capitalize(loc.getDisplayName(loc)), Styles.clearTogglet);
            button.clicked(() -> {
                if (this.getLocale().equals(loc)) {
                    return;
                }
                Core.settings.put("locale", loc.toString());
                Core.settings.save();
                Log.info("Setting locale: {0}", loc.toString());
                Vars.ui.showInfo("$language.restart");
            });
            langs.add(button).group(group).update((T t) -> t.setChecked(loc.equals(this.getLocale()))).size(400.0f, 50.0f).row();
        }
        this.cont.add(pane);
    }

    public Locale getLocale() {
        String loc = Core.settings.getString("locale");
        if (loc.equals("default")) {
            this.findClosestLocale();
        }
        if (this.lastLocale == null || !this.lastLocale.toString().equals(loc)) {
            if (loc.contains("_")) {
                String[] split = loc.split("_");
                this.lastLocale = new Locale(split[0], split[1]);
            } else {
                this.lastLocale = new Locale(loc);
            }
        }
        return this.lastLocale;
    }

    void findClosestLocale() {
        for (Locale l : Vars.locales) {
            if (!l.equals(Locale.getDefault())) continue;
            Core.settings.put("locale", l.toString());
            return;
        }
        for (Locale l : Vars.locales) {
            if (!l.getLanguage().equals(Locale.getDefault().getLanguage())) continue;
            Core.settings.put("locale", l.toString());
            return;
        }
        Core.settings.put("locale", new Locale("en").toString());
    }
}

