/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class LoadoutDialog
extends FloatingDialog {
    private Runnable hider;
    private Supplier<Array<ItemStack>> supplier;
    private Runnable resetter;
    private Runnable updater;
    private Predicate<Item> filter;
    private Table items;
    private int capacity;

    public LoadoutDialog() {
        super("$configure");
        this.setFillParent(true);
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                Core.app.post(this::hide);
            }
        });
        this.items = new Table();
        this.cont.add(this.items).left();
        this.shown(this::setup);
        this.hidden(() -> {
            if (this.hider != null) {
                this.hider.run();
            }
        });
        this.cont.row();
        this.cont.addButton("$add", () -> {
            FloatingDialog dialog = new FloatingDialog("");
            dialog.setFillParent(false);
            for (Item item2 : Vars.content.items().select(item -> this.filter.test((Item)item) && item.type == ItemType.material && this.supplier.get().find((T stack) -> stack.item == item) == null)) {
                TextButton button = dialog.cont.addButton("", Styles.cleart, () -> {
                    dialog.hide();
                    this.supplier.get().add(new ItemStack(item2, 0));
                    this.updater.run();
                    this.setup();
                }).size(300.0f, 36.0f).get();
                button.clearChildren();
                button.left();
                button.addImage(item2.icon(Item.Icon.medium)).size(24.0f).pad(4.0f);
                button.add(item2.localizedName);
                dialog.cont.row();
            }
            dialog.show();
        }).size(100.0f, 40.0f).left().disabled(b -> !Vars.content.items().contains((Item)((Object)((Predicate<Item>)item -> this.filter.test((Item)item) && !this.supplier.get().contains((ItemStack)((Object)((Predicate<ItemStack>)stack -> stack.item == item)))))));
        this.cont.row();
        this.cont.addButton("$settings.reset", () -> {
            this.resetter.run();
            this.updater.run();
            this.setup();
        }).size(210.0f, 64.0f);
        this.cont.row();
        this.cont.addImageTextButton("$back", Icon.arrowLeft, this::hide).size(210.0f, 64.0f);
    }

    public void show(int capacity, Supplier<Array<ItemStack>> supplier, Runnable reseter, Runnable updater, Runnable hider, Predicate<Item> filter) {
        this.resetter = reseter;
        this.supplier = supplier;
        this.updater = updater;
        this.capacity = capacity;
        this.hider = hider;
        this.filter = filter;
        this.show();
    }

    void setup() {
        this.items.clearChildren();
        this.items.left();
        float bsize = 40.0f;
        int step = 50;
        for (ItemStack stack : this.supplier.get()) {
            this.items.addButton("x", Styles.clearPartialt, () -> {
                this.supplier.get().remove(stack);
                this.updater.run();
                this.setup();
            }).size(bsize);
            this.items.addButton("-", Styles.clearPartialt, () -> {
                stack.amount = Math.max(stack.amount - step, 0);
                this.updater.run();
            }).size(bsize);
            this.items.addButton("+", Styles.clearPartialt, () -> {
                stack.amount = Math.min(stack.amount + step, this.capacity);
                this.updater.run();
            }).size(bsize);
            this.items.addImageButton((Drawable)Icon.pencilSmaller, Styles.clearPartial2i, () -> Vars.ui.showTextInput("$configure", stack.item.localizedName, 10, stack.amount + "", true, str -> {
                int amount;
                if (Strings.canParsePostiveInt(str) && (amount = Strings.parseInt(str)) >= 0 && amount <= this.capacity) {
                    stack.amount = amount;
                    this.updater.run();
                    return;
                }
                Vars.ui.showInfo(Core.bundle.format("configure.invalid", this.capacity));
            })).size(bsize);
            this.items.addImage(stack.item.icon(Item.Icon.medium)).size(24.0f).padRight(4.0f).padLeft(4.0f);
            this.items.label(() -> stack.amount + "").left();
            this.items.row();
        }
    }
}

