/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.Saves;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.ui.dialogs.LoadDialog;

public class SaveDialog
extends LoadDialog {
    public SaveDialog() {
        super("$savegame");
        this.update(() -> {
            if (Vars.state.is(GameState.State.menu) && this.isShown()) {
                this.hide();
            }
        });
    }

    @Override
    public void addSetup() {
        this.slots.row();
        this.slots.addImageTextButton("$save.new", Icon.add, () -> Vars.ui.showTextInput("$save", "$save.newslot", 30, "", text -> Vars.ui.loadAnd("$saving", () -> {
            Vars.control.saves.addSave((String)text);
            Core.app.post(() -> Core.app.post(this::setup));
        }))).fillX().margin(10.0f).minWidth(300.0f).height(70.0f).pad(4.0f).padRight(-4.0f);
    }

    @Override
    public void modifyButton(TextButton button, Saves.SaveSlot slot) {
        button.clicked(() -> {
            if (button.childrenPressed()) {
                return;
            }
            Vars.ui.showConfirm("$overwrite", "$save.overwrite", () -> this.save(slot));
        });
    }

    void save(Saves.SaveSlot slot) {
        Vars.ui.loadfrag.show("$saveload");
        Time.runTask(5.0f, () -> {
            this.hide();
            Vars.ui.loadfrag.hide();
            try {
                slot.save();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Vars.ui.showException("[accent]" + Core.bundle.get("savefail"), e);
            }
        });
    }
}

