/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.SettingsDialog;
import io.anuke.arc.scene.ui.Slider;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.graphics.Shaders;
import io.anuke.mindustry.input.DesktopInput;
import io.anuke.mindustry.input.MobileInput;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class SettingsMenuDialog
extends SettingsDialog {
    private SettingsDialog.SettingsTable graphics;
    private SettingsDialog.SettingsTable game;
    private SettingsDialog.SettingsTable sound;
    private Table prefs;
    private Table menu;
    private FloatingDialog dataDialog;
    private boolean wasPaused;

    public SettingsMenuDialog() {
        this.hidden(() -> {
            Sounds.back.play();
            if (!(Vars.state.is(GameState.State.menu) || this.wasPaused && !Vars.net.active())) {
                Vars.state.set(GameState.State.playing);
            }
        });
        this.shown(() -> {
            this.back();
            if (!Vars.state.is(GameState.State.menu)) {
                this.wasPaused = Vars.state.is(GameState.State.paused);
                Vars.state.set(GameState.State.paused);
            }
            this.rebuildMenu();
        });
        this.setFillParent(true);
        this.title.setAlignment(1);
        this.titleTable.row();
        this.titleTable.add(new Image()).growX().height(3.0f).pad(4.0f).get().setColor(Pal.accent);
        this.cont.clearChildren();
        this.cont.remove();
        this.buttons.remove();
        this.menu = new Table(Tex.button);
        this.game = new SettingsDialog.SettingsTable();
        this.graphics = new SettingsDialog.SettingsTable();
        this.sound = new SettingsDialog.SettingsTable();
        this.prefs = new Table();
        this.prefs.top();
        this.prefs.margin(14.0f);
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add(this.menu);
        this.dataDialog = new FloatingDialog("$settings.data");
        this.dataDialog.addCloseButton();
        this.dataDialog.cont.table(Tex.button, t -> {
            t.defaults().size(240.0f, 60.0f).left();
            TextButton.TextButtonStyle style = Styles.cleart;
            t.addButton("$settings.cleardata", style, () -> Vars.ui.showConfirm("$confirm", "$settings.clearall.confirm", () -> {
                ObjectMap<String, Object> map = new ObjectMap<String, Object>();
                for (String value : Core.settings.keys()) {
                    if (!value.contains("usid") && !value.contains("uuid")) continue;
                    map.put(value, Core.settings.getString(value));
                }
                Core.settings.clear();
                Core.settings.putAll(map);
                Core.settings.save();
                for (FileHandle file : Vars.dataDirectory.list()) {
                    file.deleteDirectory();
                }
                Core.app.exit();
            }));
            t.row();
            t.addButton("$data.export", style, () -> {
                if (Vars.ios) {
                    FileHandle file2 = Core.files.local("mindustry-data-export.zip");
                    try {
                        Vars.data.exportData(file2);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                    Vars.platform.shareFile(file2);
                } else {
                    Vars.platform.showFileChooser(false, "zip", file -> {
                        try {
                            Vars.data.exportData((FileHandle)file);
                            Vars.ui.showInfo("$data.exported");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Vars.ui.showException(e);
                        }
                    });
                }
            });
            t.row();
            t.addButton("$data.import", style, () -> Vars.ui.showConfirm("$confirm", "$data.import.confirm", () -> Vars.platform.showFileChooser(true, "zip", file -> {
                try {
                    Vars.data.importData((FileHandle)file);
                    Core.app.exit();
                }
                catch (IllegalArgumentException e) {
                    Vars.ui.showErrorMessage("$data.invalid");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage() == null || !e.getMessage().contains("too short")) {
                        Vars.ui.showException(e);
                    }
                    Vars.ui.showErrorMessage("$data.invalid");
                }
            })));
        });
        final ScrollPane pane = new ScrollPane((Element)this.prefs);
        pane.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                Element actor = pane.hit(x, y, true);
                if (actor instanceof Slider) {
                    pane.setFlickScroll(false);
                    return true;
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                pane.setFlickScroll(true);
                super.touchUp(event, x, y, pointer, button);
            }
        });
        pane.setFadeScrollBars(false);
        this.row();
        this.add(pane).grow().top();
        this.row();
        this.add(this.buttons).fillX();
        this.addSettings();
    }

    void rebuildMenu() {
        this.menu.clearChildren();
        TextButton.TextButtonStyle style = Styles.cleart;
        this.menu.defaults().size(300.0f, 60.0f);
        this.menu.addButton("$settings.game", style, () -> this.visible(0));
        this.menu.row();
        this.menu.addButton("$settings.graphics", style, () -> this.visible(1));
        this.menu.row();
        this.menu.addButton("$settings.sound", style, () -> this.visible(2));
        this.menu.row();
        this.menu.addButton("$settings.language", style, Vars.ui.language::show);
        if (!Vars.mobile || Core.settings.getBool("keyboard")) {
            this.menu.row();
            this.menu.addButton("$settings.controls", style, Vars.ui.controls::show);
        }
        this.menu.row();
        this.menu.addButton("$settings.data", style, () -> this.dataDialog.show());
    }

    void addSettings() {
        this.sound.sliderPref("musicvol", Core.bundle.get("setting.musicvol.name", "Music Volume"), 100, 0, 100, 1, i -> i + "%");
        this.sound.sliderPref("sfxvol", Core.bundle.get("setting.sfxvol.name", "SFX Volume"), 100, 0, 100, 1, i -> i + "%");
        this.sound.sliderPref("ambientvol", Core.bundle.get("setting.ambientvol.name", "Ambient Volume"), 100, 0, 100, 1, i -> i + "%");
        this.game.screenshakePref();
        if (Vars.mobile) {
            this.game.checkPref("autotarget", true);
            this.game.checkPref("keyboard", false, val -> Vars.control.setInput(val ? new DesktopInput() : new MobileInput()));
            if (Core.settings.getBool("keyboard")) {
                Vars.control.setInput(new DesktopInput());
            }
        }
        this.game.sliderPref("saveinterval", 60, 10, 600, i -> Core.bundle.format("setting.seconds", i));
        if (!Vars.mobile) {
            this.game.checkPref("crashreport", true);
        }
        this.game.checkPref("savecreate", true);
        if (Vars.steam) {
            this.game.checkPref("publichost", false, i -> Vars.platform.updateLobby());
        }
        this.game.pref(new SettingsDialog.SettingsTable.Setting(){

            @Override
            public void add(SettingsDialog.SettingsTable table) {
                table.addButton("$tutorial.retake", () -> {
                    SettingsMenuDialog.this.hide();
                    Vars.control.playTutorial();
                }).size(220.0f, 60.0f).pad(6.0f).left();
                table.add();
                table.row();
                SettingsMenuDialog.this.hide();
            }
        });
        this.graphics.sliderPref("uiscale", 100, 25, 400, 25, s -> {
            if (Vars.ui.settings != null) {
                Core.settings.put("uiscalechanged", true);
            }
            return s + "%";
        });
        this.graphics.sliderPref("fpscap", 240, 5, 245, 5, s -> s > 240 ? Core.bundle.get("setting.fpscap.none") : Core.bundle.format("setting.fpscap.text", s));
        this.graphics.sliderPref("chatopacity", 100, 0, 100, 5, s -> s + "%");
        if (!Vars.mobile) {
            this.graphics.checkPref("vsync", true, b -> Core.graphics.setVSync(b));
            this.graphics.checkPref("fullscreen", false, b -> {
                if (b) {
                    Core.graphics.setFullscreenMode(Core.graphics.getDisplayMode());
                } else {
                    Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
                }
            });
            this.graphics.checkPref("borderlesswindow", false, b -> Core.graphics.setUndecorated(b));
            Core.graphics.setVSync(Core.settings.getBool("vsync"));
            if (Core.settings.getBool("fullscreen")) {
                Core.app.post(() -> Core.graphics.setFullscreenMode(Core.graphics.getDisplayMode()));
            }
            if (Core.settings.getBool("borderlesswindow")) {
                Core.app.post(() -> Core.graphics.setUndecorated(true));
            }
        } else {
            this.graphics.checkPref("landscape", false, b -> {
                if (b) {
                    Vars.platform.beginForceLandscape();
                } else {
                    Vars.platform.endForceLandscape();
                }
            });
            if (Core.settings.getBool("landscape")) {
                Vars.platform.beginForceLandscape();
            }
        }
        this.graphics.checkPref("effects", true);
        this.graphics.checkPref("playerchat", true);
        this.graphics.checkPref("minimap", !Vars.mobile);
        this.graphics.checkPref("fps", false);
        this.graphics.checkPref("indicators", true);
        this.graphics.checkPref("animatedwater", false);
        if (Shaders.shield != null) {
            this.graphics.checkPref("animatedshields", !Vars.mobile);
        }
        this.graphics.checkPref("bloom", false, val -> Vars.renderer.toggleBloom(val));
        this.graphics.checkPref("lasers", true);
        this.graphics.checkPref("pixelate", false, val -> {
            if (val) {
                Events.fire(EventType.Trigger.enablePixelation);
            }
        });
        this.graphics.checkPref("linear", !Vars.mobile, b -> {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = b ? Texture.TextureFilter.Linear : Texture.TextureFilter.Nearest;
                tex.setFilter(filter, filter);
            }
        });
        if (Core.settings.getBool("linear")) {
            for (Texture tex : Core.atlas.getTextures()) {
                Texture.TextureFilter filter = Texture.TextureFilter.Linear;
                tex.setFilter(filter, filter);
            }
        }
    }

    private void back() {
        this.rebuildMenu();
        this.prefs.clearChildren();
        this.prefs.add(this.menu);
    }

    private void visible(int index) {
        this.prefs.clearChildren();
        this.prefs.add((new Table[]{this.game, this.graphics, this.sound})[index]);
    }

    @Override
    public void addCloseButton() {
        this.buttons.addImageTextButton("$back", Icon.arrowLeftSmaller, () -> {
            if (this.prefs.getChildren().first() != this.menu) {
                this.back();
            } else {
                this.hide();
            }
        }).size(230.0f, 64.0f);
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                this.hide();
            }
        });
    }
}

