/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.Core;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.ui.fragments.Fragment;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class BlockConfigFragment
extends Fragment {
    private Table table = new Table();
    private Tile configTile;
    private Block configBlock;

    @Override
    public void build(Group parent) {
        this.table.visible(false);
        parent.addChild(this.table);
        Core.scene.add(new Element(){

            @Override
            public void act(float delta) {
                super.act(delta);
                if (Vars.state.is(GameState.State.menu)) {
                    BlockConfigFragment.this.table.visible(false);
                    BlockConfigFragment.this.configTile = null;
                }
            }
        });
    }

    public boolean isShown() {
        return this.table.isVisible() && this.configTile != null;
    }

    public Tile getSelectedTile() {
        return this.configTile;
    }

    public void showConfig(Tile tile) {
        this.configTile = tile;
        this.configBlock = tile.block();
        this.table.visible(true);
        this.table.clear();
        tile.block().buildTable(tile, this.table);
        this.table.pack();
        this.table.setTransform(true);
        this.table.actions(Actions.scaleTo(0.0f, 1.0f), Actions.visible(true), Actions.scaleTo(1.0f, 1.0f, 0.07f, Interpolation.pow3Out));
        this.table.update(() -> {
            if (this.configTile != null && this.configTile.block().shouldHideConfigure(this.configTile, Vars.player)) {
                this.hideConfig();
                return;
            }
            this.table.setOrigin(1);
            if (this.configTile == null || this.configTile.block() == Blocks.air || this.configTile.block() != this.configBlock) {
                this.hideConfig();
            } else {
                this.configTile.block().updateTableAlign(tile, this.table);
            }
        });
    }

    public boolean hasConfigMouse() {
        Element e = Core.scene.hit(Core.input.mouseX(), Core.graphics.getHeight() - Core.input.mouseY(), true);
        return e != null && (e == this.table || e.isDescendantOf(this.table));
    }

    public void hideConfig() {
        this.configTile = null;
        this.table.actions(Actions.scaleTo(0.0f, 1.0f, 0.06f, Interpolation.pow3Out), Actions.visible(false));
    }
}

