/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.Core;
import io.anuke.arc.Input;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.BitmapFont;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.GlyphLayout;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.ui.fragments.Fragment;

public class ChatFragment
extends Table {
    private static final int messagesShown = 10;
    private Array<ChatMessage> messages = new Array();
    private float fadetime;
    private boolean chatOpen = false;
    private TextField chatfield;
    private Label fieldlabel = new Label(">");
    private BitmapFont font;
    private GlyphLayout layout = new GlyphLayout();
    private float offsetx = Scl.scl(4.0f);
    private float offsety = Scl.scl(4.0f);
    private float fontoffsetx = Scl.scl(2.0f);
    private float chatspace = Scl.scl(50.0f);
    private Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private float textspacing = Scl.scl(10.0f);
    private Array<String> history = new Array();
    private int historyPos = 0;
    private int scrollPos = 0;
    private Fragment container = new Fragment(){

        @Override
        public void build(Group parent) {
            Core.scene.add(ChatFragment.this);
        }
    };

    public ChatFragment() {
        this.setFillParent(true);
        this.font = Fonts.def;
        this.visible(() -> {
            if (!Vars.net.active() && this.messages.size > 0) {
                this.clearMessages();
                if (this.chatOpen) {
                    this.hide();
                }
            }
            return Vars.net.active();
        });
        this.update(() -> {
            if (Vars.net.active() && Core.input.keyTap(Binding.chat) && (Core.scene.getKeyboardFocus() == this.chatfield || Core.scene.getKeyboardFocus() == null)) {
                this.toggle();
            }
            if (this.chatOpen) {
                if (Core.input.keyTap(Binding.chat_history_prev) && this.historyPos < this.history.size - 1) {
                    if (this.historyPos == 0) {
                        this.history.set(0, this.chatfield.getText());
                    }
                    ++this.historyPos;
                    this.updateChat();
                }
                if (Core.input.keyTap(Binding.chat_history_next) && this.historyPos > 0) {
                    --this.historyPos;
                    this.updateChat();
                }
                this.scrollPos = (int)Mathf.clamp((float)this.scrollPos + Core.input.axis(Binding.chat_scroll), 0.0f, (float)Math.max(0, this.messages.size - 10));
            }
        });
        this.history.insert(0, "");
        this.setup();
    }

    public Fragment container() {
        return this.container;
    }

    public void clearMessages() {
        this.messages.clear();
        this.history.clear();
        this.history.insert(0, "");
    }

    private void setup() {
        this.fieldlabel.setStyle(new Label.LabelStyle(this.fieldlabel.getStyle()));
        this.fieldlabel.getStyle().font = this.font;
        this.fieldlabel.setStyle(this.fieldlabel.getStyle());
        this.chatfield = new TextField("", new TextField.TextFieldStyle(Core.scene.getStyle(TextField.TextFieldStyle.class)));
        this.chatfield.setMaxLength(150);
        this.chatfield.getStyle().background = null;
        this.chatfield.getStyle().font = Fonts.chat;
        this.chatfield.getStyle().fontColor = Color.white;
        this.chatfield.setStyle(this.chatfield.getStyle());
        this.bottom().left().marginBottom(this.offsety).marginLeft(this.offsetx * 2.0f).add(this.fieldlabel).padBottom(6.0f);
        this.add(this.chatfield).padBottom(this.offsety).padLeft(this.offsetx).growX().padRight(this.offsetx).height(28.0f);
        if (Vars.mobile) {
            this.marginBottom(105.0f);
            this.marginRight(240.0f);
        }
    }

    @Override
    public void draw() {
        float opacity = (float)Core.settings.getInt("chatopacity") / 100.0f;
        float textWidth = Math.min((float)Core.graphics.getWidth() / 1.5f, Scl.scl(700.0f));
        Draw.color(this.shadowColor);
        if (this.chatOpen) {
            Fill.crect(this.offsetx, this.chatfield.getY(), this.chatfield.getWidth() + 15.0f, this.chatfield.getHeight() - 1.0f);
        }
        super.draw();
        float spacing = this.chatspace;
        this.chatfield.visible(this.chatOpen);
        this.fieldlabel.visible(this.chatOpen);
        Draw.color(this.shadowColor);
        Draw.alpha(this.shadowColor.a * opacity);
        float theight = this.offsety + spacing + this.getMarginBottom();
        for (int i = this.scrollPos; i < this.messages.size && i < 10 + this.scrollPos && ((float)i < this.fadetime || this.chatOpen); ++i) {
            this.layout.setText(this.font, this.messages.get((int)i).formattedMessage, Color.white, textWidth, 12, true);
            theight += this.layout.height + this.textspacing;
            if (i - this.scrollPos == 0) {
                theight -= this.textspacing + 1.0f;
            }
            this.font.getCache().clear();
            this.font.getCache().addText(this.messages.get((int)i).formattedMessage, this.fontoffsetx + this.offsetx, this.offsety + theight, textWidth, 12, true);
            if (!this.chatOpen && this.fadetime - (float)i < 1.0f && this.fadetime - (float)i >= 0.0f) {
                this.font.getCache().setAlphas((this.fadetime - (float)i) * opacity);
                Draw.color(0.0f, 0.0f, 0.0f, this.shadowColor.a * (this.fadetime - (float)i) * opacity);
            } else {
                this.font.getCache().setAlphas(opacity);
            }
            Fill.crect(this.offsetx, theight - this.layout.height - 2.0f, textWidth + Scl.scl(4.0f), this.layout.height + this.textspacing);
            Draw.color(this.shadowColor);
            Draw.alpha(opacity * this.shadowColor.a);
            this.font.getCache().draw();
        }
        Draw.color();
        if (this.fadetime > 0.0f && !this.chatOpen) {
            this.fadetime -= Time.delta() / 180.0f;
        }
    }

    private void sendMessage() {
        String message = this.chatfield.getText();
        this.clearChatInput();
        if (message.replaceAll(" ", "").isEmpty()) {
            return;
        }
        this.history.insert(1, message);
        Call.sendChatMessage(message);
    }

    public void toggle() {
        if (!this.chatOpen) {
            Core.scene.setKeyboardFocus(this.chatfield);
            boolean bl = this.chatOpen = !this.chatOpen;
            if (Vars.mobile) {
                Input.TextInput input = new Input.TextInput();
                input.maxLength = 150;
                input.accepted = text -> {
                    this.chatfield.setText((String)text);
                    this.sendMessage();
                    this.hide();
                    Core.input.setOnscreenKeyboardVisible(false);
                };
                input.canceled = this::hide;
                Core.input.getTextInput(input);
            } else {
                this.chatfield.fireClick();
            }
        } else {
            Core.scene.setKeyboardFocus(null);
            this.chatOpen = !this.chatOpen;
            this.scrollPos = 0;
            this.sendMessage();
        }
    }

    public void hide() {
        Core.scene.setKeyboardFocus(null);
        this.chatOpen = false;
        this.clearChatInput();
    }

    public void updateChat() {
        this.chatfield.setText(this.history.get(this.historyPos));
        this.chatfield.setCursorPosition(this.chatfield.getText().length());
    }

    public void clearChatInput() {
        this.historyPos = 0;
        this.history.set(0, "");
        this.chatfield.setText("");
    }

    public boolean chatOpen() {
        return this.chatOpen;
    }

    public int getMessagesSize() {
        return this.messages.size;
    }

    public void addMessage(String message, String sender) {
        this.messages.insert(0, new ChatMessage(message, sender));
        this.fadetime += 1.0f;
        this.fadetime = Math.min(this.fadetime, 10.0f) + 1.0f;
    }

    private static class ChatMessage {
        public final String sender;
        public final String message;
        public final String formattedMessage;

        public ChatMessage(String message, String sender) {
            this.message = message;
            this.sender = sender;
            this.formattedMessage = sender == null ? message : "[CORAL][[" + sender + "[CORAL]]:[WHITE] " + message;
        }
    }
}

