/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Stack;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Scaling;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.UnlockableContent;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.ui.IntFormat;
import io.anuke.mindustry.ui.Minimap;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.fragments.Fragment;
import io.anuke.mindustry.ui.fragments.PlacementFragment;
import java.lang.invoke.LambdaMetafactory;

public class HudFragment
extends Fragment {
    public final PlacementFragment blockfrag = new PlacementFragment();
    private ImageButton flip;
    private Table lastUnlockTable;
    private Table lastUnlockLayout;
    private boolean shown = true;
    private float dsize = 59.0f;
    private float coreAttackTime;
    private float lastCoreHP;
    private Team lastTeam;
    private float coreAttackOpacity = 0.0f;
    private long lastToast;

    @Override
    public void build(Group parent) {
        parent.fill(cont -> {
            cont.top().left();
            if (Vars.mobile) {
                Table select = new Table();
                select.left();
                select.defaults().size(this.dsize).left();
                ImageButton.ImageButtonStyle style = Styles.clearTransi;
                select.addImageButton((Drawable)Icon.menuLarge, style, Vars.ui.paused::show);
                this.flip = select.addImageButton((Drawable)Icon.arrowUp, style, this::toggleMenus).get();
                select.addImageButton((Drawable)Icon.pause, style, () -> {
                    if (Vars.net.active()) {
                        Vars.ui.listfrag.toggle();
                    } else {
                        Vars.state.set(Vars.state.is(GameState.State.paused) ? GameState.State.playing : GameState.State.paused);
                    }
                }).name("pause").update(i -> {
                    if (Vars.net.active()) {
                        i.getStyle().imageUp = Icon.players;
                    } else {
                        i.setDisabled(false);
                        i.getStyle().imageUp = Vars.state.is(GameState.State.paused) ? Icon.play : Icon.pause;
                    }
                }).get();
                select.addImageButton((Drawable)Icon.settings, style, () -> {
                    if (Vars.net.active() && Vars.mobile) {
                        if (Vars.ui.chatfrag.chatOpen()) {
                            Vars.ui.chatfrag.hide();
                        } else {
                            Vars.ui.chatfrag.toggle();
                        }
                    } else if (Vars.world.isZone()) {
                        Vars.ui.tech.show();
                    } else {
                        Vars.ui.database.show();
                    }
                }).update(i -> {
                    i.getStyle().imageUp = Vars.net.active() && Vars.mobile ? Icon.chat : Icon.database;
                }).get();
                select.addImage().color(Pal.gray).width(4.0f).fillY();
                float size = Scl.scl(this.dsize);
                Array<Element> children = new Array<Element>(select.getChildren());
                int index = 0;
                for (Element elem : children) {
                    int fi = index++;
                    parent.addChild(elem);
                    elem.visible(() -> {
                        if (fi < 4) {
                            elem.setSize(size);
                        } else {
                            elem.setSize(Scl.scl(4.0f), size);
                        }
                        elem.setPosition((float)fi * size, Core.graphics.getHeight(), 10);
                        return true;
                    });
                }
                cont.add().size(this.dsize * 4.0f + 3.0f, this.dsize).left();
                cont.row();
                cont.addImage().height(4.0f).color(Pal.gray).fillX();
                cont.row();
            }
            cont.update(() -> {
                if (!(Core.input.keyDown(Binding.gridMode) || !Core.input.keyTap(Binding.toggle_menus) || Vars.ui.chatfrag.chatOpen() || Core.scene.hasDialog() || Core.scene.getKeyboardFocus() instanceof TextField)) {
                    this.toggleMenus();
                }
            });
            Element[] elementArray = new Element[2];
            Table wavesMain = new Table();
            elementArray[0] = wavesMain;
            Table editorMain = new Table();
            elementArray[1] = editorMain;
            cont.stack(elementArray).height(wavesMain.getPrefHeight());
            wavesMain.visible(() -> this.shown && !Vars.state.isEditor());
            wavesMain.top().left();
            Stack stack = new Stack();
            Button waves = new Button(Styles.waveb);
            Table btable = new Table().margin(0.0f);
            stack.add(waves);
            stack.add(btable);
            this.addWaveTable(waves);
            this.addPlayButton(btable);
            wavesMain.add(stack).width(this.dsize * 4.0f + 4.0f);
            wavesMain.row();
            wavesMain.table(Tex.button, t -> t.margin(10.0f).add(new Bar("boss.health", Pal.health, () -> Vars.state.boss() == null ? 0.0f : Vars.state.boss().healthf()).blink(Color.white)).grow()).fillX().visible(() -> Vars.state.rules.waves && Vars.state.boss() != null).height(60.0f).get();
            wavesMain.row();
            editorMain.table(Tex.buttonEdge4, t -> {
                t.add("$editor.teams").growX().left();
                t.row();
                t.table(teams -> {
                    teams.left();
                    int i = 0;
                    for (Team team : Team.all) {
                        ImageButton button = teams.addImageButton(Tex.whiteui, Styles.clearTogglePartiali, 40.0f, () -> Call.setPlayerTeamEditor(Vars.player, team)).size(50.0f).margin(6.0f).get();
                        button.getImageCell().grow();
                        button.getStyle().imageUpColor = team.color;
                        button.update(() -> button.setChecked(Vars.player.getTeam() == team));
                        if (++i % 3 != 0) continue;
                        teams.row();
                    }
                }).left();
            }).width(this.dsize * 4.0f + 4.0f);
            editorMain.visible(() -> this.shown && Vars.state.isEditor());
            cont.table(info -> {
                info.top().left().margin(4.0f).visible(() -> Core.settings.getBool("fps"));
                info.update(() -> info.setTranslation(Vars.state.rules.waves || Vars.state.isEditor() ? 0.0f : -Scl.scl(this.dsize * 4.0f + 3.0f), 0.0f));
                IntFormat fps = new IntFormat("fps");
                IntFormat ping = new IntFormat("ping");
                info.label(() -> fps.get(Core.graphics.getFramesPerSecond())).left().style(Styles.outlineLabel);
                info.row();
                info.label(() -> ping.get(Vars.netClient.getPing())).visible(Vars.net::client).left().style(Styles.outlineLabel);
            }).top().left();
        });
        parent.fill(t -> t.top().right().add(new Minimap()).visible(() -> Core.settings.getBool("minimap") && !Vars.state.rules.tutorial));
        parent.fill(t -> {
            t.touchable(Touchable.disabled);
            t.table((Drawable)Styles.black, (Consumer<Table>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$null$29(io.anuke.arc.scene.ui.layout.Table ), (Lio/anuke/arc/scene/ui/layout/Table;)V)()).margin((float)6.0f).update((Consumer<Table>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$null$30(io.anuke.arc.scene.ui.layout.Table ), (Lio/anuke/arc/scene/ui/layout/Table;)V)()).get().color.a = 0.0f;
        });
        parent.fill(t -> {
            t.visible(() -> Vars.netServer.isWaitingForPlayers());
            t.table(Tex.button, c -> c.add("$waiting.players"));
        });
        parent.fill(t -> {
            t.touchable(Touchable.disabled);
            float notifDuration = 240.0f;
            Events.on(EventType.StateChangeEvent.class, event -> {
                if (event.to == GameState.State.menu || event.from == GameState.State.menu) {
                    this.coreAttackTime = 0.0f;
                    this.lastCoreHP = Float.NaN;
                }
            });
            t.top().visible(() -> {
                if (Vars.state.is(GameState.State.menu) || Vars.state.teams.get((Team)Vars.player.getTeam()).cores.size == 0 || Vars.state.teams.get((Team)Vars.player.getTeam()).cores.first().entity == null) {
                    this.coreAttackTime = 0.0f;
                    return false;
                }
                float curr = Vars.state.teams.get((Team)Vars.player.getTeam()).cores.first().entity.health;
                if (this.lastTeam != Vars.player.getTeam()) {
                    this.lastCoreHP = curr;
                    this.lastTeam = Vars.player.getTeam();
                    return false;
                }
                if (!Float.isNaN(this.lastCoreHP) && curr < this.lastCoreHP) {
                    this.coreAttackTime = notifDuration;
                }
                this.lastCoreHP = curr;
                t.getColor().a = this.coreAttackOpacity;
                this.coreAttackOpacity = this.coreAttackTime > 0.0f ? Mathf.lerpDelta(this.coreAttackOpacity, 1.0f, 0.1f) : Mathf.lerpDelta(this.coreAttackOpacity, 0.0f, 0.1f);
                this.coreAttackTime -= Time.delta();
                this.lastTeam = Vars.player.getTeam();
                return this.coreAttackOpacity > 0.0f;
            });
            t.table(Tex.button, top -> top.add("$coreattack").pad(2.0f).update(label -> label.getColor().set(Color.orange).lerp(Color.scarlet, Mathf.absin(Time.time(), 2.0f, 1.0f)))).touchable(Touchable.disabled);
        });
        parent.fill(t -> {
            Runnable resize = () -> {
                t.clearChildren();
                t.top().right().visible(() -> Vars.state.rules.tutorial);
                t.stack(new Button(){
                    {
                        this.marginLeft(48.0f);
                        this.labelWrap(() -> Vars.control.tutorial.stage.text() + (Vars.control.tutorial.canNext() ? "\n\n" + Core.bundle.get("tutorial.next") : "")).width(!Core.graphics.isPortrait() ? 400.0f : 160.0f).pad(2.0f);
                        this.clicked(() -> Vars.control.tutorial.nextSentence());
                        this.setDisabled(() -> !Vars.control.tutorial.canNext());
                    }
                }, new Table(f -> f.left().addImageButton((Drawable)Icon.arrowLeftSmall, Styles.emptyi, () -> Vars.control.tutorial.prevSentence()).width(44.0f).growY().visible(() -> Vars.control.tutorial.canPrev())));
            };
            resize.run();
            Events.on(EventType.ResizeEvent.class, e -> resize.run());
        });
        parent.fill(t -> {
            t.top().visible(() -> Vars.state.isPaused()).touchable(Touchable.disabled);
            t.table(Tex.buttonTrans, top -> top.add("$paused").pad(5.0f));
        });
        parent.fill(t -> {
            t.bottom().visible(() -> Vars.control.saves.isSaving());
            t.add("$saveload").style(Styles.outlineLabel);
        });
        this.blockfrag.build(parent);
    }

    public static void setPlayerTeamEditor(Player player, Team team) {
        if (Vars.state.isEditor()) {
            player.setTeam(team);
        }
    }

    public static void spawnUnitEditor(Player player, UnitType type) {
        if (Vars.state.isEditor()) {
            BaseUnit unit = type.create(player.getTeam());
            unit.set(player.x, player.y);
            unit.rotation = player.rotation;
            unit.add();
        }
    }

    public static void removeUnitEditor(Player player, BaseUnit unit) {
        if (Vars.state.isEditor() && unit != null) {
            unit.remove();
        }
    }

    private void scheduleToast(Runnable run) {
        long duration = 3500L;
        long since = Time.timeSinceMillis(this.lastToast);
        if (since > duration) {
            this.lastToast = Time.millis();
            run.run();
        } else {
            Time.runTask((float)(duration - since) / 1000.0f * 60.0f, run);
            this.lastToast += duration;
        }
    }

    public void showToast(String text) {
        if (Vars.state.is(GameState.State.menu)) {
            return;
        }
        this.scheduleToast(() -> {
            Sounds.message.play();
            Table table = new Table(Tex.button);
            table.update(() -> {
                if (Vars.state.is(GameState.State.menu)) {
                    table.remove();
                }
            });
            table.margin(12.0f);
            table.addImage(Icon.check).pad(3.0f);
            table.add(text).wrap().width(280.0f).get().setAlignment(1, 1);
            table.pack();
            Table container = Core.scene.table();
            container.top().add(table);
            container.setTranslation(0.0f, table.getPrefHeight());
            container.actions(Actions.translateBy(0.0f, -table.getPrefHeight(), 1.0f, Interpolation.fade), Actions.delay(2.5f), Actions.run(() -> container.actions(Actions.translateBy(0.0f, table.getPrefHeight(), 1.0f, Interpolation.fade), Actions.remove())));
        });
    }

    public boolean shown() {
        return this.shown;
    }

    public void showUnlock(UnlockableContent content) {
        if (content.getContentIcon() == null || Vars.state.is(GameState.State.menu) || Vars.state.rules.tutorial) {
            return;
        }
        Sounds.message.play();
        if (this.lastUnlockTable == null) {
            this.scheduleToast(() -> {
                Table table = new Table(Tex.button);
                table.update(() -> {
                    if (Vars.state.is(GameState.State.menu)) {
                        table.remove();
                        this.lastUnlockLayout = null;
                        this.lastUnlockTable = null;
                    }
                });
                table.margin(12.0f);
                Table in = new Table();
                Image image = new Image(content.getContentIcon());
                image.setScaling(Scaling.fit);
                in.add(image).size(48.0f).pad(2.0f);
                table.add(in).padRight(8.0f);
                table.add("$unlocked");
                table.pack();
                Table container = Core.scene.table();
                container.top().add(table);
                container.setTranslation(0.0f, table.getPrefHeight());
                container.actions(Actions.translateBy(0.0f, -table.getPrefHeight(), 1.0f, Interpolation.fade), Actions.delay(2.5f), Actions.run(() -> container.actions(Actions.translateBy(0.0f, table.getPrefHeight(), 1.0f, Interpolation.fade), Actions.run(() -> {
                    this.lastUnlockTable = null;
                    this.lastUnlockLayout = null;
                }), Actions.remove())));
                this.lastUnlockTable = container;
                this.lastUnlockLayout = in;
            });
        } else {
            int col = 3;
            int cap = col * col - 1;
            Array<Element> elements = new Array<Element>(this.lastUnlockLayout.getChildren());
            int esize = elements.size;
            if (esize > cap) {
                return;
            }
            float size = 48.0f / (float)Math.min(elements.size + 1, col);
            this.lastUnlockLayout.clearChildren();
            this.lastUnlockLayout.defaults().size(size).pad(2.0f);
            for (int i = 0; i < esize; ++i) {
                this.lastUnlockLayout.add(elements.get(i));
                if (i % col != col - 1) continue;
                this.lastUnlockLayout.row();
            }
            if (esize < cap) {
                Image image = new Image(content.getContentIcon());
                image.setScaling(Scaling.fit);
                this.lastUnlockLayout.add(image);
            } else {
                this.lastUnlockLayout.addImage(Icon.add);
            }
            this.lastUnlockLayout.pack();
        }
    }

    public void showLaunch() {
        Image image = new Image();
        image.getColor().a = 0.0f;
        image.setFillParent(true);
        image.actions(Actions.fadeIn(0.6666667f));
        image.update(() -> {
            if (Vars.state.is(GameState.State.menu)) {
                image.remove();
            }
        });
        Core.scene.add(image);
    }

    public void showLand() {
        Image image = new Image();
        image.getColor().a = 1.0f;
        image.touchable(Touchable.disabled);
        image.setFillParent(true);
        image.actions(Actions.fadeOut(0.8f), Actions.remove());
        image.update(() -> {
            image.toFront();
            if (Vars.state.is(GameState.State.menu)) {
                image.remove();
            }
        });
        Core.scene.add(image);
    }

    private void showLaunchConfirm() {
        FloatingDialog dialog = new FloatingDialog("$launch");
        dialog.update(() -> {
            if (!this.inLaunchWave()) {
                dialog.hide();
            }
        });
        dialog.cont.add("$launch.confirm").width(500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.addButton("$cancel", dialog::hide);
        dialog.buttons.addButton("$ok", () -> {
            dialog.hide();
            Call.launchZone();
        });
        dialog.keyDown(KeyCode.ESCAPE, dialog::hide);
        dialog.keyDown(KeyCode.BACK, dialog::hide);
        dialog.show();
    }

    private boolean inLaunchWave() {
        return Vars.world.isZone() && Vars.world.getZone().metCondition() && !Vars.net.client() && Vars.state.wave % Vars.world.getZone().launchPeriod == 0 && !Vars.spawner.isSpawning();
    }

    private boolean canLaunch() {
        return this.inLaunchWave() && Vars.state.enemies() <= 0;
    }

    private void toggleMenus() {
        if (this.flip != null) {
            this.flip.getStyle().imageUp = this.shown ? Icon.arrowDown : Icon.arrowUp;
        }
        this.shown = !this.shown;
    }

    private void addWaveTable(Button table) {
        StringBuilder ibuild = new StringBuilder();
        IntFormat wavef = new IntFormat("wave");
        IntFormat enemyf = new IntFormat("wave.enemy");
        IntFormat enemiesf = new IntFormat("wave.enemies");
        IntFormat waitingf = new IntFormat("wave.waiting", i -> {
            ibuild.setLength(0);
            int m = i / 60;
            int s = i % 60;
            if (m <= 0) {
                ibuild.append(s);
            } else {
                ibuild.append(m);
                ibuild.append(":");
                if (s < 10) {
                    ibuild.append("0");
                }
                ibuild.append(s);
            }
            return ibuild.toString();
        });
        table.clearChildren();
        table.touchable(Touchable.enabled);
        StringBuilder builder = new StringBuilder();
        table.setName("waves");
        table.labelWrap(() -> {
            builder.setLength(0);
            builder.append(wavef.get(Vars.state.wave));
            builder.append("\n");
            if (this.inLaunchWave()) {
                builder.append("[#");
                Tmp.c1.set(Color.white).lerp(Vars.state.enemies() > 0 ? Color.white : Color.scarlet, Mathf.absin(Time.time(), 2.0f, 1.0f)).toString(builder);
                builder.append("]");
                if (!this.canLaunch()) {
                    builder.append(Core.bundle.get("launch.unable2"));
                } else {
                    builder.append(Core.bundle.get("launch"));
                    builder.append("\n");
                    builder.append(Core.bundle.format("launch.next", Vars.state.wave + Vars.world.getZone().launchPeriod));
                    builder.append("\n");
                }
                builder.append("[]\n");
            }
            if (Vars.state.enemies() > 0) {
                if (Vars.state.enemies() == 1) {
                    builder.append(enemyf.get(Vars.state.enemies()));
                } else {
                    builder.append(enemiesf.get(Vars.state.enemies()));
                }
                builder.append("\n");
            }
            if (Vars.state.rules.waveTimer) {
                builder.append(Vars.state.rules.waitForWaveToEnd && Vars.unitGroups[Vars.waveTeam.ordinal()].size() > 0 ? Core.bundle.get("wave.waveInProgress") : waitingf.get((int)(Vars.state.wavetime / 60.0f)));
            } else if (Vars.state.enemies() == 0) {
                builder.append(Core.bundle.get("waiting"));
            }
            return builder;
        }).growX().pad(8.0f);
        table.setDisabled(() -> !this.canLaunch());
        table.visible(() -> Vars.state.rules.waves);
        table.clicked(() -> {
            if (this.canLaunch()) {
                this.showLaunchConfirm();
            }
        });
    }

    private boolean canSkipWave() {
        return Vars.state.rules.waves && (Vars.net.server() || Vars.player.isAdmin || !Vars.net.active()) && Vars.state.enemies() == 0 && !Vars.spawner.isSpawning() && !Vars.state.rules.tutorial;
    }

    private void addPlayButton(Table table) {
        table.right().addImageButton(Icon.playSmaller, Styles.righti, 30.0f, () -> {
            if (Vars.net.client() && Vars.player.isAdmin) {
                Call.onAdminRequest(Vars.player, Packets.AdminAction.wave);
            } else if (this.inLaunchWave()) {
                Vars.ui.showConfirm("$confirm", "$launch.skip.confirm", () -> !this.canSkipWave(), () -> {
                    Vars.state.wavetime = 0.0f;
                });
            } else {
                Vars.state.wavetime = 0.0f;
            }
        }).growY().fillX().right().width(40.0f).visible(this::canSkipWave);
    }

    private static /* synthetic */ void lambda$null$30(Table u) {
        u.color.a = Mathf.lerpDelta(u.color.a, Mathf.num(Vars.spawner.playerNear()), 0.1f);
    }

    private static /* synthetic */ void lambda$null$29(Table c) {
        c.add("$nearpoint").update(l -> l.setColor(Tmp.c1.set(Color.white).lerp(Color.scarlet, Mathf.absin(Time.time(), 10.0f, 1.0f)))).get().setAlignment(1, 1);
    }

    private static /* synthetic */ void lambda$null$17(float[] size, float[] position, TextButton b) {
        Element e;
        boolean[] found = new boolean[]{false};
        if (b.isChecked() && (e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true)) == null) {
            Vector2 world = Core.input.mouseWorld();
            Units.nearby(world.x, world.y, 1.0f, 1.0f, unit -> {
                if (!found[0] && unit instanceof BaseUnit) {
                    if (Core.input.keyTap(KeyCode.MOUSE_LEFT)) {
                        Call.removeUnitEditor(Vars.player, (BaseUnit)unit);
                    }
                    found[0] = true;
                    unit.hitbox(Tmp.r1);
                    size[0] = Mathf.lerpDelta(size[0], Tmp.r1.width * 2.0f + Mathf.absin(Time.time(), 10.0f, 5.0f), 0.1f);
                    position[0] = unit.x;
                    position[1] = unit.y;
                }
            });
        }
        Draw.color(Pal.accent, Color.white, Mathf.absin(Time.time(), 8.0f, 1.0f));
        Lines.poly(position[0], position[1], 4, size[0] / 2.0f);
        Draw.reset();
        if (!found[0]) {
            size[0] = Mathf.lerpDelta(size[0], 0.0f, 0.2f);
        }
    }

    private static /* synthetic */ void lambda$null$15() {
    }

    private static /* synthetic */ void lambda$null$14() {
        FloatingDialog dialog = new FloatingDialog("$editor.spawn");
        int i = 0;
        for (UnitType type : Vars.content.getBy(ContentType.unit)) {
            dialog.cont.addImageButton((Drawable)Tex.whiteui, (float)48.0f, (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$null$13(io.anuke.mindustry.type.UnitType io.anuke.mindustry.ui.dialogs.FloatingDialog ), ()V)((UnitType)type, (FloatingDialog)dialog)).get().getStyle().imageUp = new TextureRegionDrawable(type.iconRegion);
            if (++i % 4 != 0) continue;
            dialog.cont.row();
        }
        dialog.addCloseButton();
        dialog.setFillParent(false);
        dialog.show();
    }

    private static /* synthetic */ void lambda$null$13(UnitType type, FloatingDialog dialog) {
        Call.spawnUnitEditor(Vars.player, type);
        dialog.hide();
    }
}

