/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.function.FloatProvider;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.fragments.Fragment;

public class LoadingFragment
extends Fragment {
    private Table table;
    private TextButton button;
    private Bar bar;

    @Override
    public void build(Group parent) {
        parent.fill(Styles.black8, t -> {
            t.visible(false);
            t.touchable(Touchable.enabled);
            t.add().height(133.0f).row();
            t.addImage().growX().height(3.0f).pad(4.0f).growX().get().setColor(Pal.accent);
            t.row();
            t.add("$loading").name("namelabel").pad(10.0f);
            t.row();
            t.addImage().growX().height(3.0f).pad(4.0f).growX().get().setColor(Pal.accent);
            t.row();
            this.bar = t.add(new Bar()).pad(3.0f).size(500.0f, 40.0f).visible(false).get();
            t.row();
            this.button = t.addButton("$cancel", () -> {}).pad(20.0f).size(250.0f, 70.0f).visible(false).get();
            this.table = t;
        });
    }

    public void setProgress(FloatProvider progress) {
        this.bar.visible(true);
        this.bar.set(() -> (int)(progress.get() * 100.0f) + "%", progress, Pal.accent);
    }

    public void setButton(Runnable listener) {
        this.button.visible(true);
        this.button.getListeners().remove(this.button.getListeners().size - 1);
        this.button.clicked(listener);
    }

    public void setText(String text) {
        ((Label)this.table.find("namelabel")).setText(text);
        ((Label)this.table.find("namelabel")).setColor(Pal.accent);
    }

    public void show() {
        this.show("$loading");
    }

    public void show(String text) {
        ((Label)this.table.find("namelabel")).setColor(Color.white);
        this.bar.visible(false);
        this.table.clearActions();
        this.table.touchable(Touchable.enabled);
        ((Label)this.table.find("namelabel")).setText(text);
        this.table.visible(true);
        this.table.getColor().a = 1.0f;
        this.table.toFront();
    }

    public void hide() {
        this.table.clearActions();
        this.table.toFront();
        this.table.touchable(Touchable.disabled);
        this.table.actions(Actions.fadeOut(0.5f), Actions.visible(false));
    }
}

