/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.scene.ui.layout.WidgetGroup;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Version;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.graphics.MenuRenderer;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.ui.MobileButton;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.fragments.Fragment;

public class MenuFragment
extends Fragment {
    private Table container;
    private Table submenu;
    private Button currentMenu;
    private MenuRenderer renderer;

    public MenuFragment() {
        Core.assets.load("sprites/logo.png", Texture.class);
        Core.assets.finishLoading();
        Events.on(EventType.DisposeEvent.class, event -> this.renderer.dispose());
    }

    @Override
    public void build(Group parent) {
        this.renderer = new MenuRenderer();
        WidgetGroup group = new WidgetGroup();
        ((Element)group).setFillParent(true);
        group.visible(() -> !Vars.ui.editor.isShown());
        parent.addChild(group);
        parent = group;
        parent.fill((x, y, w, h) -> this.renderer.render());
        parent.fill(c -> {
            this.container = c;
            if (!Vars.mobile) {
                this.buildDesktop();
                Events.on(EventType.ResizeEvent.class, event -> this.buildDesktop());
            } else {
                this.buildMobile();
                Events.on(EventType.ResizeEvent.class, event -> this.buildMobile());
            }
        });
        if (Vars.mobile) {
            parent.fill(c -> c.bottom().left().addButton("", Styles.infot, Vars.ui.about::show).size(84.0f, 45.0f));
            parent.fill(c -> c.bottom().right().addButton("", Styles.discordt, Vars.ui.discord::show).size(84.0f, 45.0f));
        }
        String versionText = "[#ffffffba]" + (Version.build == -1 ? "[#fc8140aa]custom build" : (Version.type.equals("official") ? Version.modifier : Version.type) + " build " + Version.build);
        parent.fill((x, y, w, h) -> {
            Texture logo = (Texture)Core.assets.get("sprites/logo.png");
            float logoscl = Scl.scl(1.0f);
            float logow = Math.min((float)logo.getWidth() * logoscl, (float)Core.graphics.getWidth() - Scl.scl(20.0f));
            float logoh = logow * (float)logo.getHeight() / (float)logo.getWidth();
            float fx = (int)((float)Core.graphics.getWidth() / 2.0f);
            float fy = (float)((int)((float)(Core.graphics.getHeight() - 6) - logoh)) + logoh / 2.0f - (Core.graphics.isPortrait() ? Scl.scl(30.0f) : 0.0f);
            Draw.color();
            Draw.rect(Draw.wrap(logo), fx, fy, logow, logoh);
            Fonts.def.setColor(Color.white);
            Fonts.def.draw(versionText, fx, fy - logoh / 2.0f, 1);
        }).touchable(Touchable.disabled);
    }

    private void buildMobile() {
        this.container.clear();
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float size = 120.0f;
        this.container.defaults().size(size).pad(5.0f).padTop(4.0f);
        MobileButton play = new MobileButton((Drawable)Icon.play2, "$campaign", Vars.ui.deploy::show);
        MobileButton custom = new MobileButton((Drawable)Icon.playCustom, "$customgame", Vars.ui.custom::show);
        MobileButton maps = new MobileButton((Drawable)Icon.load, "$loadgame", Vars.ui.load::show);
        MobileButton join = new MobileButton((Drawable)Icon.add, "$joingame", Vars.ui.join::show);
        MobileButton editor = new MobileButton((Drawable)Icon.editor, "$editor", Vars.ui.maps::show);
        MobileButton tools = new MobileButton((Drawable)Icon.tools, "$settings", Vars.ui.settings::show);
        MobileButton donate = new MobileButton((Drawable)Icon.link, "$website", () -> Core.net.openURI("https://anuke.itch.io/mindustry"));
        MobileButton exit = new MobileButton((Drawable)Icon.exit, "$quit", () -> Core.app.exit());
        if (!Core.graphics.isPortrait()) {
            this.container.marginTop(60.0f);
            this.container.add(play);
            this.container.add(join);
            this.container.add(custom);
            if (Vars.ios) {
                this.container.row();
            }
            this.container.add(maps);
            if (!Vars.ios) {
                this.container.row();
            }
            this.container.table(table -> {
                table.defaults().set(this.container.defaults());
                table.add(editor);
                table.add(tools);
                if (Vars.platform.canDonate()) {
                    table.add(donate);
                }
                if (!Vars.ios) {
                    table.add(exit);
                }
            }).colspan(4);
        } else {
            this.container.marginTop(0.0f);
            this.container.add(play);
            this.container.add(maps);
            this.container.row();
            this.container.add(custom);
            this.container.add(join);
            this.container.row();
            this.container.add(editor);
            this.container.add(tools);
            this.container.row();
            this.container.table(table -> {
                table.defaults().set(this.container.defaults());
                if (Vars.platform.canDonate()) {
                    table.add(donate);
                }
                if (!Vars.ios) {
                    table.add(exit);
                }
            }).colspan(2);
        }
    }

    private void buildDesktop() {
        this.container.clear();
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float width = 230.0f;
        Drawable background = Styles.black6;
        this.container.left();
        this.container.add().width((float)Core.graphics.getWidth() / 10.0f);
        this.container.table(background, t -> {
            t.defaults().width(width).height(70.0f);
            Buttoni[] buttoniArray = new Buttoni[6];
            Buttoni[] buttoniArray2 = new Buttoni[5];
            buttoniArray2[0] = new Buttoni("$campaign", (Drawable)Icon.play2Small, Vars.ui.deploy::show);
            buttoniArray2[1] = new Buttoni("$joingame", (Drawable)Icon.addSmall, Vars.ui.join::show);
            buttoniArray2[2] = new Buttoni("$customgame", (Drawable)Icon.editorSmall, Vars.ui.custom::show);
            buttoniArray2[3] = new Buttoni("$loadgame", (Drawable)Icon.loadSmall, Vars.ui.load::show);
            buttoniArray2[4] = new Buttoni("$tutorial", (Drawable)Icon.infoSmall, Vars.control::playTutorial);
            buttoniArray[0] = new Buttoni("$play", (Drawable)Icon.play2Small, buttoniArray2);
            buttoniArray[1] = new Buttoni("$editor", (Drawable)Icon.editorSmall, Vars.ui.maps::show);
            buttoniArray[2] = Vars.steam ? new Buttoni("$workshop", (Drawable)Icon.saveSmall, Vars.platform::openWorkshop) : null;
            buttoniArray[3] = new Buttoni("$settings", (Drawable)Icon.toolsSmall, Vars.ui.settings::show);
            buttoniArray[4] = new Buttoni("$about.button", (Drawable)Icon.infoSmall, Vars.ui.about::show);
            buttoniArray[5] = new Buttoni("$quit", (Drawable)Icon.exitSmall, Core.app::exit);
            this.buttons((Table)t, buttoniArray);
        }).width(width).growY();
        this.container.table(background, t -> {
            this.submenu = t;
            t.getColor().a = 0.0f;
            t.top();
            t.defaults().width(width).height(70.0f);
            t.visible(() -> !t.getChildren().isEmpty());
        }).width(width).growY();
    }

    private void fadeInMenu() {
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f, 0.15f, Interpolation.fade));
    }

    private void fadeOutMenu() {
        if (this.submenu.getChildren().isEmpty()) {
            return;
        }
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f), Actions.alpha(0.0f, 0.2f, Interpolation.fade), Actions.run(() -> this.submenu.clearChildren()));
    }

    private void buttons(Table t, Buttoni ... buttons) {
        for (Buttoni b : buttons) {
            if (b == null) continue;
            Button[] out = new Button[]{null};
            out[0] = t.addImageTextButton(b.text, b.icon, Styles.clearToggleMenut, () -> {
                if (this.currentMenu == out[0]) {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                } else if (b.submenu != null) {
                    this.currentMenu = out[0];
                    this.submenu.clearChildren();
                    this.fadeInMenu();
                    this.submenu.add().height(((float)Core.graphics.getHeight() - out[0].getY(10)) / Scl.scl(1.0f));
                    this.submenu.row();
                    this.buttons(this.submenu, b.submenu);
                } else {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                    b.runnable.run();
                }
            }).marginLeft(11.0f).get();
            out[0].update(() -> out[0].setChecked(this.currentMenu == out[0]));
            t.row();
        }
    }

    private class Buttoni {
        final Drawable icon;
        final String text;
        final Runnable runnable;
        final Buttoni[] submenu;

        public Buttoni(String text, Drawable icon, Runnable runnable) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = null;
        }

        public Buttoni(String text, Drawable icon, Buttoni ... buttons) {
            this.icon = icon;
            this.text = text;
            this.runnable = () -> {};
            this.submenu = buttons;
        }
    }
}

