/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.type.Category;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.fragments.Fragment;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class PlacementFragment
extends Fragment {
    final int rowWidth = 4;
    Array<Block> returnArray = new Array();
    Array<Category> returnCatArray = new Array();
    boolean[] categoryEmpty = new boolean[Category.all.length];
    Category currentCategory = Category.distribution;
    Block hovered;
    Block lastDisplay;
    Tile lastHover;
    Tile hoverTile;
    Table blockTable;
    Table toggler;
    Table topTable;
    boolean lastGround;
    final KeyCode[] inputGrid = new KeyCode[]{KeyCode.NUM_1, KeyCode.NUM_2, KeyCode.NUM_3, KeyCode.NUM_4, KeyCode.Q, KeyCode.W, KeyCode.E, KeyCode.R, KeyCode.A, KeyCode.S, KeyCode.D, KeyCode.F, KeyCode.Z, KeyCode.X, KeyCode.C, KeyCode.V};
    final KeyCode[] inputCatGrid = new KeyCode[]{KeyCode.NUM_1, KeyCode.NUM_2, KeyCode.Q, KeyCode.W, KeyCode.A, KeyCode.S, KeyCode.Z, KeyCode.X, KeyCode.C, KeyCode.V};

    public PlacementFragment() {
        Events.on(EventType.WorldLoadEvent.class, event -> Core.app.post(() -> {
            Vars.control.input.block = null;
            this.rebuild();
        }));
        Events.on(EventType.UnlockEvent.class, event -> {
            if (event.content instanceof Block) {
                this.rebuild();
            }
        });
    }

    void rebuild() {
        this.currentCategory = Category.turret;
        Group group = this.toggler.getParent();
        int index = this.toggler.getZIndex();
        this.toggler.remove();
        this.build(group);
        this.toggler.setZIndex(index);
    }

    boolean gridUpdate(InputHandler input) {
        KeyCode[] tryRecipe;
        Tile tile;
        if (Core.input.keyDown(Binding.pick) && (tile = Vars.world.tileWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) != null && (tryRecipe = (tile = tile.link()).block()).isVisible() && this.unlocked((Block)tryRecipe)) {
            input.block = tryRecipe;
            this.currentCategory = input.block.buildCategory;
            return true;
        }
        if (!Core.input.keyDown(Binding.gridMode) || Vars.ui.chatfrag.chatOpen()) {
            return false;
        }
        if (Core.input.keyDown(Binding.gridModeShift)) {
            int i = 0;
            for (KeyCode key : this.inputCatGrid) {
                if (Core.input.keyDown(key)) {
                    input.block = this.getByCategory(Category.all[i]).first();
                    this.currentCategory = input.block.buildCategory;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        Array<Block> recipes = this.getByCategory(this.currentCategory);
        for (KeyCode key : this.inputGrid) {
            if (Core.input.keyDown(key)) {
                input.block = i < recipes.size && this.unlocked(recipes.get(i)) ? recipes.get(i) : null;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void build(Group parent) {
        parent.fill(full -> {
            this.toggler = full;
            full.bottom().right().visible(() -> Vars.ui.hudfrag.shown());
            full.table(frame -> {
                Runnable rebuildCategory = () -> {
                    this.blockTable.clear();
                    this.blockTable.top().margin(5.0f);
                    int index = 0;
                    ButtonGroup group = new ButtonGroup();
                    group.setMinCheckCount(0);
                    for (Block block : this.getByCategory(this.currentCategory)) {
                        if (index++ % 4 == 0) {
                            this.blockTable.row();
                        }
                        if (!this.unlocked(block)) {
                            this.blockTable.add().size(46.0f);
                            continue;
                        }
                        ImageButton button = this.blockTable.addImageButton((Drawable)Icon.lockedSmall, Styles.selecti, () -> {
                            if (this.unlocked(block)) {
                                Vars.control.input.block = Vars.control.input.block == block ? null : block;
                            }
                        }).size(46.0f).group(group).name("block-" + block.name).get();
                        button.getStyle().imageUp = new TextureRegionDrawable(block.icon(Block.Icon.medium));
                        button.update(() -> {
                            TileEntity core = Vars.player.getClosestCore();
                            Color color = Vars.state.rules.infiniteResources || core != null && (core.items.has(block.buildRequirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources) ? Color.white : Color.gray;
                            button.forEach(elem -> elem.setColor(color));
                            button.setChecked(Vars.control.input.block == block);
                        });
                        button.hovered(() -> {
                            this.hovered = block;
                        });
                        button.exited(() -> {
                            if (this.hovered == block) {
                                this.hovered = null;
                            }
                        });
                    }
                    if (index < 4) {
                        for (int i = 0; i < 4 - index; ++i) {
                            this.blockTable.add().size(46.0f);
                        }
                    }
                    this.blockTable.act(0.0f);
                };
                frame.table(Tex.buttonEdge2, top -> {
                    this.topTable = top;
                    top.add(new Table()).growX().update(topTable -> {
                        if (this.tileDisplayBlock() == null && this.lastDisplay == this.getSelected() && !this.lastGround || this.tileDisplayBlock() != null && this.lastHover == this.hoverTile && this.lastDisplay == this.tileDisplayBlock() && this.lastGround) {
                            return;
                        }
                        topTable.clear();
                        topTable.top().left().margin(5.0f);
                        this.lastHover = this.hoverTile;
                        this.lastDisplay = this.getSelected();
                        boolean bl = this.lastGround = this.tileDisplayBlock() != null;
                        if (this.lastDisplay != null) {
                            this.lastGround = false;
                            topTable.table(header -> {
                                header.left();
                                header.add(new Image(this.lastDisplay.icon(Block.Icon.medium))).size(32.0f);
                                header.labelWrap(() -> !this.unlocked(this.lastDisplay) ? Core.bundle.get("block.unknown") : this.lastDisplay.localizedName).left().width(190.0f).padLeft(5.0f);
                                header.add().growX();
                                if (this.unlocked(this.lastDisplay)) {
                                    header.addButton("?", Styles.clearPartialt, () -> {
                                        Vars.ui.content.show(this.lastDisplay);
                                        Events.fire(new EventType.BlockInfoEvent());
                                    }).size(40.0f).padTop(-5.0f).padRight(-5.0f).right().grow().name("blockinfo");
                                }
                            }).growX().left();
                            topTable.row();
                            topTable.table(req -> {
                                req.top().left();
                                for (ItemStack stack : this.lastDisplay.buildRequirements) {
                                    req.table(line -> {
                                        line.left();
                                        line.addImage(stack.item.icon(Item.Icon.small)).size(16.0f);
                                        line.add(stack.item.localizedName()).color(Color.lightGray).padLeft(2.0f).left();
                                        line.labelWrap(() -> {
                                            int stackamount;
                                            TileEntity core = Vars.player.getClosestCore();
                                            if (core == null || Vars.state.rules.infiniteResources) {
                                                return "*/*";
                                            }
                                            int amount = core.items.get(stack.item);
                                            String color = (float)amount < (float)(stackamount = Math.round((float)stack.amount * Vars.state.rules.buildCostMultiplier)) / 2.0f ? "[red]" : (amount < stackamount ? "[accent]" : "[white]");
                                            return color + Vars.ui.formatAmount(amount) + "[white]/" + stackamount;
                                        }).padLeft(5.0f);
                                    }).left();
                                    req.row();
                                }
                            }).growX().left().margin(3.0f);
                        } else if (this.tileDisplayBlock() != null) {
                            this.lastDisplay = this.tileDisplayBlock();
                            topTable.table(t -> {
                                t.left();
                                t.add(new Image(this.lastDisplay.getDisplayIcon(this.hoverTile))).size(32.0f);
                                t.labelWrap(this.lastDisplay.getDisplayName(this.hoverTile)).left().width(190.0f).padLeft(5.0f);
                            }).growX().left();
                            if (this.hoverTile.getTeam() == Vars.player.getTeam()) {
                                topTable.row();
                                topTable.table(t -> {
                                    t.left().defaults().left();
                                    this.lastDisplay.display(this.hoverTile, (Table)t);
                                }).left().growX();
                            }
                        }
                    });
                }).colspan(3).fillX().visible(() -> this.getSelected() != null || this.tileDisplayBlock() != null).touchable(Touchable.enabled);
                frame.row();
                frame.addImage().color(Pal.gray).colspan(3).height(4.0f).growX();
                frame.row();
                frame.table(Tex.pane2, blocksSelect -> {
                    blocksSelect.margin(4.0f).marginTop(0.0f);
                    blocksSelect.table(blocks -> {
                        this.blockTable = blocks;
                    }).grow();
                    blocksSelect.row();
                    blocksSelect.table(Vars.control.input::buildUI).name("inputTable").growX();
                }).fillY().bottom().touchable(Touchable.enabled);
                frame.table(categories -> {
                    categories.defaults().size(50.0f);
                    ButtonGroup group = new ButtonGroup();
                    for (Category cat : Category.all) {
                        Array<Block> blocks = this.getByCategory(cat);
                        this.categoryEmpty[cat.ordinal()] = blocks.isEmpty() || !this.unlocked(blocks.first());
                    }
                    int f = 0;
                    for (Category cat : this.getCategories()) {
                        if (f++ % 2 == 0) {
                            categories.row();
                        }
                        if (this.categoryEmpty[cat.ordinal()]) {
                            categories.addImage(Styles.black6);
                            continue;
                        }
                        categories.addImageButton(Core.atlas.drawable("icon-" + cat.name() + "-smaller"), Styles.clearToggleTransi, () -> {
                            this.currentCategory = cat;
                            rebuildCategory.run();
                        }).group(group).update(i -> i.setChecked(this.currentCategory == cat)).name("category-" + cat.name());
                    }
                }).touchable(Touchable.enabled);
                rebuildCategory.run();
                frame.update(() -> {
                    if (this.gridUpdate(Vars.control.input)) {
                        rebuildCategory.run();
                    }
                });
            });
        });
    }

    Array<Category> getCategories() {
        this.returnCatArray.clear();
        this.returnCatArray.addAll((Category[])Category.all);
        this.returnCatArray.sort((c1, c2) -> Boolean.compare(this.categoryEmpty[c1.ordinal()], this.categoryEmpty[c2.ordinal()]));
        return this.returnCatArray;
    }

    Array<Block> getByCategory(Category cat) {
        this.returnArray.clear();
        for (Block block : Vars.content.blocks()) {
            if (block.buildCategory != cat || !block.isVisible()) continue;
            this.returnArray.add(block);
        }
        this.returnArray.sort((b1, b2) -> -Boolean.compare(this.unlocked((Block)b1), this.unlocked((Block)b2)));
        return this.returnArray;
    }

    boolean unlocked(Block block) {
        return !Vars.world.isZone() || Vars.data.isUnlocked(block);
    }

    Block getSelected() {
        Tile tile;
        Block toDisplay = null;
        Vector2 v = this.topTable.stageToLocalCoordinates(Core.input.mouse());
        this.hoverTile = !Core.scene.hasMouse() && this.topTable.hit(v.x, v.y, false) == null ? ((tile = Vars.world.tileWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) != null ? tile.link() : null) : null;
        if (Vars.control.input.block != null) {
            toDisplay = Vars.control.input.block;
        }
        if (this.hovered != null) {
            toDisplay = this.hovered;
        }
        return toDisplay;
    }

    Block tileDisplayBlock() {
        return this.hoverTile == null ? null : (this.hoverTile.block().synthetic() ? this.hoverTile.block() : (this.hoverTile.drop() != null ? (this.hoverTile.overlay().itemDrop != null ? this.hoverTile.overlay() : this.hoverTile.floor()) : null));
    }
}

