/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Scaling;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.net.NetConnection;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.fragments.Fragment;

public class PlayerListFragment
extends Fragment {
    private boolean visible = false;
    private Table content = new Table().marginRight(13.0f).marginLeft(13.0f);
    private Interval timer = new Interval();

    @Override
    public void build(Group parent) {
        parent.fill(cont -> {
            cont.visible(() -> this.visible);
            cont.update(() -> {
                if (!Vars.net.active() || Vars.state.is(GameState.State.menu)) {
                    this.visible = false;
                    return;
                }
                if (this.visible && this.timer.get(20.0f)) {
                    this.rebuild();
                    this.content.pack();
                    this.content.act(Core.graphics.getDeltaTime());
                    Core.scene.act(0.0f);
                }
            });
            cont.table(Tex.buttonTrans, pane -> {
                pane.label(() -> Core.bundle.format(Vars.playerGroup.size() == 1 ? "players.single" : "players", Vars.playerGroup.size()));
                pane.row();
                pane.pane(this.content).grow().get().setScrollingDisabled(true, false);
                pane.row();
                pane.table(menu -> {
                    menu.defaults().growX().height(50.0f).fillY();
                    menu.addButton("$server.bans", Vars.ui.bans::show).disabled(b -> Vars.net.client());
                    menu.addButton("$server.admins", Vars.ui.admins::show).disabled(b -> Vars.net.client());
                    menu.addButton("$close", this::toggle);
                }).margin(0.0f).pad(10.0f).growX();
            }).touchable(Touchable.enabled).margin(14.0f);
        });
        this.rebuild();
    }

    public void rebuild() {
        this.content.clear();
        float h = 74.0f;
        Vars.playerGroup.all().sort((p1, p2) -> p1.getTeam().compareTo(p2.getTeam()));
        Vars.playerGroup.all().each(user -> {
            NetConnection connection = user.con;
            if (connection == null && Vars.net.server() && !user.isLocal) {
                return;
            }
            Table button = new Table();
            button.left();
            button.margin(5.0f).marginBottom(10.0f);
            Table table = new Table(){

                @Override
                public void draw() {
                    super.draw();
                    Draw.color(Pal.gray);
                    Draw.alpha(this.parentAlpha);
                    Lines.stroke(Scl.scl(4.0f));
                    Lines.rect(this.x, this.y, this.width, this.height);
                    Draw.reset();
                }
            };
            table.margin(8.0f);
            table.add(new Image(user.mech.getContentIcon()).setScaling(Scaling.none)).grow();
            button.add(table).size(h);
            button.labelWrap("[#" + user.color.toString().toUpperCase() + "]" + user.name).width(170.0f).pad(10.0f);
            button.add().grow();
            button.addImage(Icon.admin).visible(() -> user.isAdmin && (user.isLocal || !Vars.net.server())).padRight(5.0f).get().updateVisibility();
            if (!(!Vars.net.server() && !Vars.player.isAdmin || user.isLocal || user.isAdmin && !Vars.net.server())) {
                button.add().growY();
                float bs = h / 2.0f;
                button.table(t -> {
                    t.defaults().size(bs);
                    t.addImageButton((Drawable)Icon.banSmall, Styles.clearPartiali, () -> Vars.ui.showConfirm("$confirm", "$confirmban", () -> Call.onAdminRequest(user, Packets.AdminAction.ban)));
                    t.addImageButton((Drawable)Icon.cancelSmall, Styles.clearPartiali, () -> Vars.ui.showConfirm("$confirm", "$confirmkick", () -> Call.onAdminRequest(user, Packets.AdminAction.kick)));
                    t.row();
                    t.addImageButton((Drawable)Icon.adminSmall, Styles.clearTogglePartiali, () -> {
                        if (Vars.net.client()) {
                            return;
                        }
                        String id = user.uuid;
                        if (Vars.netServer.admins.isAdmin(id, connection.address)) {
                            Vars.ui.showConfirm("$confirm", "$confirmunadmin", () -> Vars.netServer.admins.unAdminPlayer(id));
                        } else {
                            Vars.ui.showConfirm("$confirm", "$confirmadmin", () -> Vars.netServer.admins.adminPlayer(id, user.usid));
                        }
                    }).update(b -> b.setChecked(user.isAdmin)).disabled(b -> Vars.net.client()).touchable(() -> Vars.net.client() ? Touchable.disabled : Touchable.enabled).checked(user.isAdmin);
                    t.addImageButton((Drawable)Icon.zoomSmall, Styles.clearPartiali, () -> Call.onAdminRequest(user, Packets.AdminAction.trace));
                }).padRight(12.0f).size(bs + 10.0f, bs);
            } else if (!user.isLocal && !user.isAdmin && Vars.net.client() && Vars.playerGroup.size() >= 3) {
                button.add().growY();
                button.addImageButton((Drawable)Icon.banSmall, Styles.clearPartiali, () -> Vars.ui.showConfirm("$confirm", "$confirmvotekick", () -> Call.sendChatMessage("/votekick " + user.name))).size(h);
            }
            this.content.add(button).padBottom(-6.0f).width(350.0f).maxHeight(h + 14.0f);
            this.content.row();
            this.content.addImage().height(4.0f).color(Vars.state.rules.pvp ? user.getTeam().color : Pal.gray).growX();
            this.content.row();
        });
        this.content.marginBottom(5.0f);
    }

    public void toggle() {
        boolean bl = this.visible = !this.visible;
        if (this.visible) {
            this.rebuild();
        }
    }
}

