/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.collection.Array;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.UnlockableContent;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Edges;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.Consumers;
import io.anuke.mindustry.world.meta.BlockBars;
import io.anuke.mindustry.world.meta.BlockStats;

public abstract class BlockStorage
extends UnlockableContent {
    public boolean hasItems;
    public boolean hasLiquids;
    public boolean hasPower;
    public boolean outputsLiquid = false;
    public boolean consumesPower = true;
    public boolean outputsPower = false;
    public int itemCapacity = 10;
    public float liquidCapacity = 10.0f;
    public final BlockStats stats = new BlockStats();
    public final BlockBars bars = new BlockBars();
    public final Consumers consumes = new Consumers();

    public BlockStorage(String name) {
        super(name);
    }

    public boolean shouldConsume(Tile tile) {
        return true;
    }

    public float getPowerProduction(Tile tile) {
        return 0.0f;
    }

    public int acceptStack(Item item, int amount, Tile tile, Unit source) {
        if (this.acceptItem(item, tile, tile) && this.hasItems && (source == null || source.getTeam() == tile.getTeam())) {
            return Math.min(this.getMaximumAccepted(tile, item) - tile.entity.items.get(item), amount);
        }
        return 0;
    }

    public int getMaximumAccepted(Tile tile, Item item) {
        return this.itemCapacity;
    }

    public int removeStack(Tile tile, Item item, int amount) {
        if (tile.entity == null || tile.entity.items == null) {
            return 0;
        }
        amount = Math.min(amount, tile.entity.items.get(item));
        tile.entity.noSleep();
        tile.entity.items.remove(item, amount);
        return amount;
    }

    public void handleStack(Item item, int amount, Tile tile, Unit source) {
        tile.entity.noSleep();
        tile.entity.items.add(item, amount);
    }

    public boolean outputsItems() {
        return this.hasItems;
    }

    public void getStackOffset(Item item, Tile tile, Vector2 trns) {
    }

    public void onProximityUpdate(Tile tile) {
        if (tile.entity != null) {
            tile.entity.noSleep();
        }
    }

    public void handleItem(Item item, Tile tile, Tile source) {
        tile.entity.items.add(item, 1);
    }

    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return this.consumes.itemFilters[item.id] && tile.entity.items.get(item) < this.getMaximumAccepted(tile, item);
    }

    public boolean acceptLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        return this.hasLiquids && tile.entity.liquids.get(liquid) + amount < this.liquidCapacity && this.consumes.liquidfilters[liquid.id];
    }

    public void handleLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        tile.entity.liquids.add(liquid, amount);
    }

    public void tryDumpLiquid(Tile tile, Liquid liquid) {
        Array<Tile> proximity = tile.entity.proximity();
        byte dump = tile.rotation();
        for (int i = 0; i < proximity.size; ++i) {
            float fract;
            float ofract;
            this.incrementDump(tile, proximity.size);
            Tile other = proximity.get((i + dump) % proximity.size);
            Tile in = Edges.getFacingEdge(tile, other);
            if (other.getTeam() != tile.getTeam() || !other.block().hasLiquids || !this.canDumpLiquid(tile, other, liquid) || other.entity.liquids == null || !((ofract = other.entity.liquids.get(liquid) / other.block().liquidCapacity) < (fract = tile.entity.liquids.get(liquid) / this.liquidCapacity))) continue;
            this.tryMoveLiquid(tile, in, other, (fract - ofract) * this.liquidCapacity / 2.0f, liquid);
        }
    }

    public boolean canDumpLiquid(Tile tile, Tile to, Liquid liquid) {
        return true;
    }

    public void tryMoveLiquid(Tile tile, Tile tileSource, Tile next, float amount, Liquid liquid) {
        float flow = Math.min(next.block().liquidCapacity - next.entity.liquids.get(liquid) - 0.001f, amount);
        if (next.block().acceptLiquid(next, tileSource, liquid, flow)) {
            next.block().handleLiquid(next, tileSource, liquid, flow);
            tile.entity.liquids.remove(liquid, flow);
        }
    }

    public float tryMoveLiquid(Tile tile, Tile next, boolean leak, Liquid liquid) {
        if (next == null) {
            return 0.0f;
        }
        if ((next = next.link()).getTeam() == tile.getTeam() && next.block().hasLiquids && tile.entity.liquids.get(liquid) > 0.0f) {
            if (next.block().acceptLiquid(next, tile, liquid, 0.0f)) {
                float ofract = next.entity.liquids.get(liquid) / next.block().liquidCapacity;
                float fract = tile.entity.liquids.get(liquid) / this.liquidCapacity;
                float flow = Math.min(Mathf.clamp((fract - ofract) * 1.0f) * this.liquidCapacity, tile.entity.liquids.get(liquid));
                if ((flow = Math.min(flow, next.block().liquidCapacity - next.entity.liquids.get(liquid) - 0.001f)) > 0.0f && ofract <= fract && next.block().acceptLiquid(next, tile, liquid, flow)) {
                    next.block().handleLiquid(next, tile, liquid, flow);
                    tile.entity.liquids.remove(liquid, flow);
                    return flow;
                }
                if (ofract > 0.1f && fract > 0.1f) {
                    Liquid other = next.entity.liquids.current();
                    if (other.flammability > 0.3f && liquid.temperature > 0.7f || liquid.flammability > 0.3f && other.temperature > 0.7f) {
                        tile.entity.damage(1.0f * Time.delta());
                        next.entity.damage(1.0f * Time.delta());
                        if (Mathf.chance(0.1 * (double)Time.delta())) {
                            Effects.effect(Fx.fire, (tile.worldx() + next.worldx()) / 2.0f, (tile.worldy() + next.worldy()) / 2.0f);
                        }
                    } else if (liquid.temperature > 0.7f && other.temperature < 0.55f || other.temperature > 0.7f && liquid.temperature < 0.55f) {
                        tile.entity.liquids.remove(liquid, Math.min(tile.entity.liquids.get(liquid), 0.7f * Time.delta()));
                        if (Mathf.chance(0.2f * Time.delta())) {
                            Effects.effect(Fx.steam, (tile.worldx() + next.worldx()) / 2.0f, (tile.worldy() + next.worldy()) / 2.0f);
                        }
                    }
                }
            }
        } else if (leak && !next.block().solid && !next.block().hasLiquids) {
            float leakAmount = tile.entity.liquids.get(liquid) / 1.5f;
            Puddle.deposit(next, tile, liquid, leakAmount);
            tile.entity.liquids.remove(liquid, leakAmount);
        }
        return 0.0f;
    }

    public void offloadNear(Tile tile, Item item) {
        Array<Tile> proximity = tile.entity.proximity();
        byte dump = tile.rotation();
        for (int i = 0; i < proximity.size; ++i) {
            this.incrementDump(tile, proximity.size);
            Tile other = proximity.get((i + dump) % proximity.size);
            Tile in = Edges.getFacingEdge(tile, other);
            if (other.getTeam() != tile.getTeam() || !other.block().acceptItem(item, other, in) || !this.canDump(tile, other, item)) continue;
            other.block().handleItem(item, other, in);
            return;
        }
        this.handleItem(item, tile, tile);
    }

    public boolean tryDump(Tile tile) {
        return this.tryDump(tile, null);
    }

    public boolean tryDump(Tile tile, Item todump) {
        TileEntity entity = tile.entity;
        if (entity == null || !this.hasItems || tile.entity.items.total() == 0 || todump != null && !entity.items.has(todump)) {
            return false;
        }
        Array<Tile> proximity = entity.proximity();
        byte dump = tile.rotation();
        if (proximity.size == 0) {
            return false;
        }
        for (int i = 0; i < proximity.size; ++i) {
            Tile other = proximity.get((i + dump) % proximity.size);
            Tile in = Edges.getFacingEdge(tile, other);
            if (todump == null) {
                for (int ii = 0; ii < Vars.content.items().size; ++ii) {
                    Item item = Vars.content.item(ii);
                    if (other.getTeam() != tile.getTeam() || !entity.items.has(item) || !other.block().acceptItem(item, other, in) || !this.canDump(tile, other, item)) continue;
                    other.block().handleItem(item, other, in);
                    tile.entity.items.remove(item, 1);
                    this.incrementDump(tile, proximity.size);
                    return true;
                }
            } else if (other.getTeam() == tile.getTeam() && other.block().acceptItem(todump, other, in) && this.canDump(tile, other, todump)) {
                other.block().handleItem(todump, other, in);
                tile.entity.items.remove(todump, 1);
                this.incrementDump(tile, proximity.size);
                return true;
            }
            this.incrementDump(tile, proximity.size);
        }
        return false;
    }

    protected void incrementDump(Tile tile, int prox) {
        tile.rotation((byte)((tile.rotation() + 1) % prox));
    }

    public boolean canDump(Tile tile, Tile to, Item item) {
        return true;
    }

    public boolean offloadDir(Tile tile, Item item) {
        Tile other = tile.getNearby(tile.rotation());
        if (other != null) {
            other = other.link();
        }
        if (other != null && other.getTeam() == tile.getTeam() && other.block().acceptItem(item, other, tile)) {
            other.block().handleItem(item, other, tile);
            return true;
        }
        return false;
    }

    public boolean canProduce(Tile tile) {
        return true;
    }
}

