/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Edges;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;

public class Build {
    private static final Rectangle rect = new Rectangle();

    public static void beginBreak(Team team, int x, int y) {
        if (!Build.validBreak(team, x, y)) {
            return;
        }
        Tile tile = Vars.world.ltile(x, y);
        float prevPercent = 1.0f;
        if (tile == null) {
            return;
        }
        if (tile.entity != null) {
            prevPercent = tile.entity.healthf();
        }
        byte rotation = tile.rotation();
        Block previous = tile.block();
        BuildBlock sub = BuildBlock.get(previous.size);
        Vars.world.setBlock(tile, sub, team, rotation);
        ((BuildBlock.BuildEntity)tile.entity()).setDeconstruct(previous);
        tile.entity.health = tile.entity.maxHealth() * prevPercent;
        Core.app.post(() -> Events.fire(new EventType.BlockBuildBeginEvent(tile, team, true)));
    }

    public static void beginPlace(Team team, int x, int y, Block result, int rotation) {
        if (!Build.validPlace(team, x, y, result, rotation)) {
            return;
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        Block previous = tile.block();
        BuildBlock sub = BuildBlock.get(result.size);
        Vars.world.setBlock(tile, sub, team, rotation);
        ((BuildBlock.BuildEntity)tile.entity()).setConstruct(previous, result);
        Core.app.post(() -> Events.fire(new EventType.BlockBuildBeginEvent(tile, team, false)));
    }

    public static boolean validPlace(Team team, int x, int y, Block type, int rotation) {
        if (!type.isVisible() || type.isHidden()) {
            return false;
        }
        if ((type.solid || type.solidifes) && Units.anyEntities((float)(x * 8) + type.offset() - (float)(type.size * 8) / 2.0f, (float)(y * 8) + type.offset() - (float)(type.size * 8) / 2.0f, type.size * 8, type.size * 8)) {
            return false;
        }
        for (Team enemy : Vars.state.teams.enemiesOf(team)) {
            for (Tile core : Vars.state.teams.get((Team)enemy).cores) {
                if (!(Mathf.dst((float)(x * 8) + type.offset(), (float)(y * 8) + type.offset(), core.drawx(), core.drawy()) < Vars.state.rules.enemyCoreBuildRadius + (float)(type.size * 8) / 2.0f)) continue;
                return false;
            }
        }
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return false;
        }
        if (type.isMultiblock()) {
            if (type.canReplace(tile.block()) && tile.block().size == type.size && type.canPlaceOn(tile) && tile.interactable(team)) {
                return true;
            }
            if (!Build.contactsGround(tile.x, tile.y, type)) {
                return false;
            }
            if (!type.canPlaceOn(tile)) {
                return false;
            }
            int offsetx = -(type.size - 1) / 2;
            int offsety = -(type.size - 1) / 2;
            for (int dx = 0; dx < type.size; ++dx) {
                for (int dy = 0; dy < type.size; ++dy) {
                    Tile other = Vars.world.tile(x + dx + offsetx, y + dy + offsety);
                    if (other != null && (other.block() == Blocks.air || other.block().alwaysReplace) && other.floor().placeableOn && (!other.floor().isDeep() || type.floating)) continue;
                    return false;
                }
            }
            return true;
        }
        return !(!tile.interactable(team) || !Build.contactsGround(tile.x, tile.y, type) || tile.floor().isDeep() && !type.floating || !tile.floor().placeableOn || (!type.canReplace(tile.block()) || type == tile.block() && rotation == tile.rotation() && type.rotate) && !tile.block().alwaysReplace && tile.block() != Blocks.air || tile.block().isMultiblock() != type.isMultiblock() || !type.canPlaceOn(tile));
    }

    private static boolean contactsGround(int x, int y, Block block) {
        if (block.isMultiblock()) {
            Tile tile;
            for (Point2 point : Edges.getInsideEdges(block.size)) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            for (Point2 point : Edges.getEdges(block.size)) {
                tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
        } else {
            for (Point2 point : Geometry.d4) {
                Tile tile = Vars.world.tile(x + point.x, y + point.y);
                if (tile == null || tile.floor().isDeep()) continue;
                return true;
            }
            Tile tile = Vars.world.tile(x, y);
            return tile != null && !tile.floor().isDeep();
        }
        return false;
    }

    public static boolean validBreak(Team team, int x, int y) {
        Tile tile = Vars.world.ltile(x, y);
        return tile != null && tile.block().canBreak(tile) && tile.breakable() && tile.interactable(team);
    }
}

