/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.modules.ConsumeModule;
import io.anuke.mindustry.world.modules.ItemModule;
import io.anuke.mindustry.world.modules.LiquidModule;
import io.anuke.mindustry.world.modules.PowerModule;

public class CachedTile
extends Tile {
    public CachedTile() {
        super(0, 0);
    }

    @Override
    public Team getTeam() {
        return Team.all[this.getTeamID()];
    }

    @Override
    protected void preChanged() {
        this.team = 0;
    }

    @Override
    protected void changed() {
        this.entity = null;
        Block block = this.block();
        if (block.hasEntity()) {
            TileEntity n = block.newEntity();
            n.cons = new ConsumeModule(this.entity);
            n.tile = this;
            n.block = block;
            if (block.hasItems) {
                n.items = new ItemModule();
            }
            if (block.hasLiquids) {
                n.liquids = new LiquidModule();
            }
            if (block.hasPower) {
                n.power = new PowerModule();
            }
            this.entity = n;
        }
    }
}

