/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.world.Tile;
import java.util.Arrays;

public class Edges {
    private static final int maxSize = 11;
    private static final int maxRadius = 12;
    private static Point2[][] edges;
    private static Point2[][] edgeInside;
    private static Vector2[][] polygons;

    public static Tile getFacingEdge(Tile tile, Tile other) {
        if (!tile.block().isMultiblock()) {
            return tile;
        }
        int size = tile.block().size;
        return Vars.world.tile(tile.x + Mathf.clamp(other.x - tile.x, -(size - 1) / 2, size / 2), tile.y + Mathf.clamp(other.y - tile.y, -(size - 1) / 2, size / 2));
    }

    public static Vector2[] getPixelPolygon(float radius) {
        if (radius < 1.0f || radius > 12.0f) {
            throw new RuntimeException("Polygon size must be between 1 and 12");
        }
        return polygons[(int)(radius * 2.0f) - 1];
    }

    public static Point2[] getEdges(int size) {
        if (size < 0 || size > 11) {
            throw new RuntimeException("Block size must be between 0 and 11");
        }
        return edges[size - 1];
    }

    public static Point2[] getInsideEdges(int size) {
        if (size < 0 || size > 11) {
            throw new RuntimeException("Block size must be between 0 and 11");
        }
        return edgeInside[size - 1];
    }

    static {
        int i;
        edges = new Point2[11][0];
        edgeInside = new Point2[11][0];
        polygons = new Vector2[24][0];
        for (i = 0; i < 24; ++i) {
            Edges.polygons[i] = Geometry.pixelCircle((float)(i + 1) / 2.0f);
        }
        for (i = 0; i < 11; ++i) {
            int j;
            int bot = -((int)((float)i / 2.0f)) - 1;
            int top = (int)((float)i / 2.0f + 0.5f) + 1;
            Edges.edges[i] = new Point2[(i + 1) * 4];
            int idx = 0;
            for (j = 0; j < i + 1; ++j) {
                Edges.edges[i][idx++] = new Point2(bot + 1 + j, bot);
                Edges.edges[i][idx++] = new Point2(bot + 1 + j, top);
                Edges.edges[i][idx++] = new Point2(bot, bot + j + 1);
                Edges.edges[i][idx++] = new Point2(top, bot + j + 1);
            }
            Arrays.sort(edges[i], (e1, e2) -> Float.compare(Mathf.angle(e1.x, e1.y), Mathf.angle(e2.x, e2.y)));
            Edges.edgeInside[i] = new Point2[edges[i].length];
            for (j = 0; j < edges[i].length; ++j) {
                Point2 point = edges[i][j];
                Edges.edgeInside[i][j] = new Point2(Mathf.clamp(point.x, -((int)((float)i / 2.0f)), (int)((float)i / 2.0f + 0.5f)), Mathf.clamp(point.y, -((int)((float)i / 2.0f)), (int)((float)i / 2.0f + 0.5f)));
            }
        }
    }
}

