/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.util.Pack;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.type.Item;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ItemBuffer {
    private final float speed;
    private long[] buffer;
    private int index;

    public ItemBuffer(int capacity, float speed) {
        this.buffer = new long[capacity];
        this.speed = speed;
    }

    public boolean accepts() {
        return this.index < this.buffer.length;
    }

    public void accept(Item item, short data) {
        this.buffer[this.index++] = Pack.longInt(Float.floatToIntBits(Time.time()), Pack.shortInt(item.id, data));
    }

    public void accept(Item item) {
        this.accept(item, (short)-1);
    }

    public Item poll() {
        if (this.index > 0) {
            long l = this.buffer[0];
            float time = Float.intBitsToFloat(Pack.leftInt(l));
            if (Time.time() >= time + this.speed || Time.time() < time) {
                return Vars.content.item(Pack.leftShort(Pack.rightInt(l)));
            }
        }
        return null;
    }

    public short pollData() {
        if (this.index > 0) {
            long l = this.buffer[0];
            float time = Float.intBitsToFloat(Pack.leftInt(l));
            if (Time.time() >= time + this.speed || Time.time() < time) {
                return Pack.rightShort(Pack.rightInt(l));
            }
        }
        return -1;
    }

    public void remove() {
        System.arraycopy(this.buffer, 1, this.buffer, 0, this.index - 1);
        --this.index;
    }

    public void write(DataOutput stream) throws IOException {
        stream.writeByte((byte)this.index);
        stream.writeByte((byte)this.buffer.length);
        for (long l : this.buffer) {
            stream.writeLong(l);
        }
    }

    public void read(DataInput stream) throws IOException {
        this.index = stream.readByte();
        int length = stream.readByte();
        for (int i = 0; i < length; ++i) {
            long l = stream.readLong();
            if (i >= this.buffer.length) continue;
            this.buffer[i] = l;
        }
        this.index = Math.min(this.index, length - 1);
    }
}

