/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.collection.IntMap;
import io.anuke.arc.graphics.Color;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.game.ContentList;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.blocks.Floor;

public class LegacyColorMapper
implements ContentList {
    private static IntMap<LegacyBlock> blockMap = new IntMap();
    private static LegacyBlock defaultValue;

    public static LegacyBlock get(int color) {
        return blockMap.get(color, defaultValue);
    }

    @Override
    public void load() {
        defaultValue = new LegacyBlock(Blocks.stone, Blocks.air);
        this.map("ff0000", Blocks.stone, Blocks.air, Blocks.spawn);
        this.map("00ff00", Blocks.stone);
        this.map("323232", Blocks.stone);
        this.map("646464", Blocks.stone, Blocks.rocks);
        this.map("50965a", Blocks.grass);
        this.map("5ab464", Blocks.grass, Blocks.pine);
        this.map("506eb4", Blocks.water);
        this.map("465a96", Blocks.deepwater);
        this.map("252525", Blocks.ignarock);
        this.map("575757", Blocks.ignarock, Blocks.duneRocks);
        this.map("988a67", Blocks.sand);
        this.map("e5d8bb", Blocks.sand, Blocks.duneRocks);
        this.map("c2d1d2", Blocks.snow);
        this.map("c4e3e7", Blocks.ice);
        this.map("f7feff", Blocks.snow, Blocks.snowrocks);
        this.map("6e501e", Blocks.holostone);
        this.map("ed5334", Blocks.magmarock);
        this.map("292929", Blocks.tar);
        this.map("c3a490", Blocks.stone, Blocks.air, Blocks.oreCopper);
        this.map("161616", Blocks.stone, Blocks.air, Blocks.oreCoal);
        this.map("6277bc", Blocks.stone, Blocks.air, Blocks.oreTitanium);
        this.map("83bc58", Blocks.stone, Blocks.air, Blocks.oreThorium);
    }

    private void map(String color, Block block, Block wall, Block ore) {
        blockMap.put(Color.rgba8888(Color.valueOf(color)), new LegacyBlock(block, wall, ore));
    }

    private void map(String color, Block block, Block wall) {
        blockMap.put(Color.rgba8888(Color.valueOf(color)), new LegacyBlock(block, wall));
    }

    private void map(String color, Block block) {
        blockMap.put(Color.rgba8888(Color.valueOf(color)), new LegacyBlock(block, Blocks.air));
    }

    public static class LegacyBlock {
        public final Floor floor;
        public final Block wall;
        public final Block ore;

        public LegacyBlock(Block floor, Block wall) {
            this(floor, wall, Blocks.air);
        }

        public LegacyBlock(Block floor, Block wall, Block ore) {
            this.floor = (Floor)floor;
            this.wall = wall;
            this.ore = ore;
        }
    }
}

