/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class BlockPart
extends Block {
    public static final int maxSize = 9;
    private static final BlockPart[][] parts = new BlockPart[9][9];
    private final int dx;
    private final int dy;

    public BlockPart(int dx, int dy) {
        super("part_" + dx + "_" + dy);
        this.dx = dx;
        this.dy = dy;
        this.solid = false;
        this.hasLiquids = true;
        this.hasItems = true;
        this.hasPower = true;
        BlockPart.parts[dx + 4][dy + 4] = this;
    }

    public static BlockPart get(int dx, int dy) {
        if (dx == -4 && dy == -4) {
            throw new IllegalArgumentException("Why are you getting a [0,0] blockpart? Stop it.");
        }
        return parts[dx + 4][dy + 4];
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return tile.link().block().acceptItem(item, tile.link(), source);
    }

    @Override
    public void handleItem(Item item, Tile tile, Tile source) {
        tile.link().block().handleItem(item, tile.link(), source);
    }

    @Override
    public void handleLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        Block block = tile.link().block();
        block.handleLiquid(tile.link(), source, liquid, amount);
    }

    @Override
    public boolean acceptLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        Block block = tile.link().block();
        return block.hasLiquids && block.acceptLiquid(tile.link(), source, liquid, amount);
    }

    @Override
    public Tile linked(Tile tile) {
        Tile out = tile.getNearby(-this.dx, -this.dy);
        return out == null ? tile : out;
    }

    @Override
    public void drawTeam(Tile tile) {
    }

    @Override
    public void draw(Tile tile) {
    }

    @Override
    public boolean synthetic() {
        return true;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public String toString() {
        return "BlockPart[" + this.dx + ", " + this.dy + "]";
    }
}

