/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Attributes;

public class Floor
extends Block {
    public int variants = 3;
    public String edge = "stone";
    public float speedMultiplier = 1.0f;
    public float dragMultiplier = 1.0f;
    public float damageTaken = 0.0f;
    public float drownTime = 0.0f;
    public Effects.Effect walkEffect = Fx.ripple;
    public Effects.Effect drownUpdateEffect = Fx.bubble;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 60.0f;
    public Liquid liquidDrop = null;
    public Item itemDrop = null;
    public boolean isLiquid;
    public boolean playerUnmineable = false;
    public Block blendGroup = this;
    public Effects.Effect updateEffect = Fx.none;
    public Attributes attributes = new Attributes();
    protected TextureRegion[][] edges;
    protected byte eq = 0;
    protected Array<Block> blenders = new Array();
    protected IntSet blended = new IntSet();
    protected TextureRegion edgeRegion;
    protected TextureRegion edgierRegion;

    public Floor(String name) {
        super(name);
    }

    @Override
    public void load() {
        super.load();
        if (this.variants > 0) {
            this.variantRegions = new TextureRegion[this.variants];
            for (int i = 0; i < this.variants; ++i) {
                this.variantRegions[i] = Core.atlas.find(this.name + (i + 1));
            }
        } else {
            this.variantRegions = new TextureRegion[1];
            this.variantRegions[0] = Core.atlas.find(this.name);
        }
        int size = (int)(8.0f / Draw.scl);
        if (Core.atlas.has(this.name + "-edge")) {
            this.edges = Core.atlas.find(this.name + "-edge").split(size, size);
        }
        this.region = this.variantRegions[0];
        this.edgeRegion = Core.atlas.find("edge");
        this.edgierRegion = Core.atlas.find("edgier");
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(Core.atlas.has(this.name) ? this.name : this.name + "1")};
    }

    @Override
    public void draw(Tile tile) {
        Mathf.random.setSeed(tile.pos());
        Draw.rect(this.variantRegions[Mathf.randomSeed(tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx(), tile.worldy());
        this.drawEdges(tile);
        Floor floor = tile.overlay();
        if (floor != Blocks.air && floor != this) {
            floor.draw(tile);
        }
    }

    public boolean isDeep() {
        return this.drownTime > 0.0f;
    }

    public void drawNonLayer(Tile tile) {
        Mathf.random.setSeed(tile.pos());
        this.drawEdges(tile, true);
    }

    protected void drawEdges(Tile tile) {
        this.drawEdges(tile, false);
    }

    protected void drawEdges(Tile tile, boolean sameLayer) {
        this.blenders.clear();
        this.blended.clear();
        this.eq = 0;
        for (int i = 0; i < 8; ++i) {
            Point2 point = Geometry.d8[i];
            Tile other = tile.getNearby(point);
            if (other == null || !this.doEdge(other.floor(), sameLayer) || other.floor().edges() == null) continue;
            if (this.blended.add(other.floor().id)) {
                this.blenders.add(other.floor());
            }
            this.eq = (byte)(this.eq | 1 << i);
        }
        this.blenders.sort((a, b) -> Integer.compare(a.id, b.id));
        for (Block block : this.blenders) {
            for (int i = 0; i < 8; ++i) {
                Point2 point = Geometry.d8[i];
                Tile other = tile.getNearby(point);
                if (other == null || other.floor() != block) continue;
                TextureRegion region = this.edge((Floor)block, 2 - (point.x + 1), 2 - (point.y + 1));
                Draw.rect(region, tile.worldx(), tile.worldy());
                if (sameLayer || block.cacheLayer.ordinal() <= this.cacheLayer.ordinal()) continue;
                Draw.rect(block.variantRegions()[0], tile.worldx() + (float)(point.x * 8), tile.worldy() + (float)(point.y * 8));
            }
        }
    }

    protected void drawEdgesFlat(Tile tile, boolean sameLayer) {
        for (int i = 0; i < 4; ++i) {
            Tile other = tile.getNearby(i);
            if (other == null || !this.doEdge(other.floor(), sameLayer)) continue;
            Color color = other.floor().color;
            Draw.color(color.r, color.g, color.b, 1.0f);
            Draw.rect(this.edgeRegion, tile.worldx(), tile.worldy(), (float)(i * 90));
        }
        Draw.color();
    }

    protected TextureRegion[][] edges() {
        return ((Floor)this.blendGroup).edges;
    }

    protected boolean doEdge(Floor other, boolean sameLayer) {
        return !(other.blendGroup.id <= this.blendGroup.id && this.edges() != null || !other.edgeOnto(this) || other.cacheLayer.ordinal() <= this.cacheLayer.ordinal() && sameLayer);
    }

    protected boolean edgeOnto(Floor other) {
        return true;
    }

    boolean eq(int i) {
        return (this.eq & 1 << Mathf.mod(i, 8)) != 0;
    }

    TextureRegion edge(Floor block, int x, int y) {
        return block.edges()[x][2 - y];
    }
}

