/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockGroup;
import io.anuke.mindustry.world.modules.LiquidModule;

public class LiquidBlock
extends Block {
    protected TextureRegion liquidRegion;
    protected TextureRegion bottomRegion;
    protected TextureRegion topRegion;

    public LiquidBlock(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasLiquids = true;
        this.group = BlockGroup.liquids;
        this.outputsLiquid = true;
    }

    @Override
    public void load() {
        super.load();
        this.liquidRegion = Core.atlas.find(this.name + "-liquid");
        this.topRegion = Core.atlas.find(this.name + "-top");
        this.bottomRegion = Core.atlas.find(this.name + "-bottom");
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-bottom"), Core.atlas.find(this.name + "-top")};
    }

    @Override
    public void draw(Tile tile) {
        LiquidModule mod = tile.entity.liquids;
        int rotation = this.rotate ? tile.rotation() * 90 : 0;
        Draw.rect(this.bottomRegion, tile.drawx(), tile.drawy(), (float)rotation);
        if (mod.total() > 0.001f) {
            Draw.color(mod.current().color);
            Draw.alpha(mod.total() / this.liquidCapacity);
            Draw.rect(this.liquidRegion, tile.drawx(), tile.drawy(), (float)rotation);
            Draw.color();
        }
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy(), (float)rotation);
    }
}

