/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.graphics.g2d.CapStyle;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.graphics.Shaders;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.world.Tile;

public class RespawnBlock {
    public static void drawRespawn(Tile tile, float heat, float progress, float time, Player player, Mech to) {
        progress = Mathf.clamp(progress);
        Draw.color(Pal.darkMetal);
        Lines.stroke(2.0f * heat);
        Fill.poly(tile.drawx(), tile.drawy(), 4, 10.0f * heat);
        Draw.reset();
        if (player != null) {
            TextureRegion region = to.iconRegion;
            Draw.color(0.0f, 0.0f, 0.0f, 0.4f * progress);
            Draw.rect("circle-shadow", tile.drawx(), tile.drawy(), (float)region.getWidth() / 3.0f, (float)region.getWidth() / 3.0f);
            Draw.color();
            Shaders.build.region = region;
            Shaders.build.progress = progress;
            Shaders.build.color.set(Pal.accent);
            Shaders.build.time = -time / 10.0f;
            Draw.shader(Shaders.build, true);
            Draw.rect(region, tile.drawx(), tile.drawy());
            Draw.shader();
            Draw.color(Pal.accentBack);
            float pos = Mathf.sin(time, 6.0f, 8.0f);
            Lines.lineAngleCenter(tile.drawx() + pos, tile.drawy(), 90.0f, 16.0f - Math.abs(pos) * 2.0f);
            Draw.reset();
        }
        Lines.stroke(2.0f * heat);
        Draw.color(Pal.accentBack);
        Lines.poly(tile.drawx(), tile.drawy(), 4, 8.0f * heat);
        float oy = -7.0f;
        float len = 6.0f * heat;
        Lines.stroke(5.0f);
        Draw.color(Pal.darkMetal);
        Lines.line(tile.drawx() - len, tile.drawy() + oy, tile.drawx() + len, tile.drawy() + oy, CapStyle.none);
        for (int i : Mathf.signs) {
            Fill.tri(tile.drawx() + len * (float)i, tile.drawy() + oy - Lines.getStroke() / 2.0f, tile.drawx() + len * (float)i, tile.drawy() + oy + Lines.getStroke() / 2.0f, tile.drawx() + (len + Lines.getStroke() * heat) * (float)i, tile.drawy() + oy);
        }
        Lines.stroke(3.0f);
        Draw.color(Pal.accent);
        Lines.line(tile.drawx() - len, tile.drawy() + oy, tile.drawx() - len + len * 2.0f * progress, tile.drawy() + oy, CapStyle.none);
        for (int i : Mathf.signs) {
            Fill.tri(tile.drawx() + len * (float)i, tile.drawy() + oy - Lines.getStroke() / 2.0f, tile.drawx() + len * (float)i, tile.drawy() + oy + Lines.getStroke() / 2.0f, tile.drawx() + (len + Lines.getStroke() * heat) * (float)i, tile.drawy() + oy);
        }
        Draw.reset();
        if (Vars.net.active() && player != null) {
            tile.block().drawPlaceText(player.name, tile.x, tile.y - Math.max((tile.block().size - 1) / 2, 0), true);
        }
    }
}

