/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class Rock
extends Block {
    protected int variants;

    public Rock(String name) {
        super(name);
        this.breakable = true;
        this.alwaysReplace = true;
    }

    @Override
    public void draw(Tile tile) {
        if (this.variants > 0) {
            Draw.rect(this.variantRegions[Mathf.randomSeed(tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx(), tile.worldy());
        } else {
            Draw.rect(this.region, tile.worldx(), tile.worldy());
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        TextureRegion[] textureRegionArray;
        if (this.variants == 0) {
            textureRegionArray = super.generateIcons();
        } else {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = Core.atlas.find(this.name + "1");
        }
        return textureRegionArray;
    }

    @Override
    public void load() {
        super.load();
        if (this.variants > 0) {
            this.variantRegions = new TextureRegion[this.variants];
            for (int i = 0; i < this.variants; ++i) {
                this.variantRegions[i] = Core.atlas.find(this.name + (i + 1));
            }
        }
    }
}

