/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.graphics.CacheLayer;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Rock;

public class StaticWall
extends Rock {
    TextureRegion large;
    TextureRegion[][] split;

    public StaticWall(String name) {
        super(name);
        this.alwaysReplace = false;
        this.breakable = false;
        this.solid = true;
        this.variants = 2;
        this.cacheLayer = CacheLayer.walls;
    }

    @Override
    public void draw(Tile tile) {
        int rx = tile.x / 2 * 2;
        int ry = tile.y / 2 * 2;
        if (Core.atlas.isFound(this.large) && this.eq(rx, ry) && (double)Mathf.randomSeed(Pos.get(rx, ry)) < 0.5) {
            Draw.rect(this.split[tile.x % 2][1 - tile.y % 2], tile.worldx(), tile.worldy());
        } else if (this.variants > 0) {
            Draw.rect(this.variantRegions[Mathf.randomSeed(tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx(), tile.worldy());
        } else {
            Draw.rect(this.region, tile.worldx(), tile.worldy());
        }
    }

    @Override
    public void load() {
        super.load();
        this.large = Core.atlas.find(this.name + "-large");
        this.split = this.large.split(32, 32);
    }

    boolean eq(int rx, int ry) {
        return rx < Vars.world.width() - 1 && ry < Vars.world.height() - 1 && Vars.world.tile(rx + 1, ry).block() == this && Vars.world.tile(rx, ry + 1).block() == this && Vars.world.tile(rx, ry).block() == this && Vars.world.tile(rx + 1, ry + 1).block() == this;
    }
}

