/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense;

import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.Wall;

public class DeflectorWall
extends Wall {
    public static final float hitTime = 10.0f;
    protected float maxDamageDeflect = 10.0f;
    protected Rectangle rect = new Rectangle();
    protected Rectangle rect2 = new Rectangle();

    public DeflectorWall(String name) {
        super(name);
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        DeflectorEntity entity = (DeflectorEntity)tile.entity();
        if (entity.hit < 1.0E-4f) {
            return;
        }
        Draw.color(Color.white);
        Draw.alpha(entity.hit * 0.5f);
        Draw.blend(Blending.additive);
        Fill.rect(tile.drawx(), tile.drawy(), 8 * this.size, 8 * this.size);
        Draw.blend();
        Draw.reset();
        entity.hit = Mathf.clamp(entity.hit - Time.delta() / 10.0f);
    }

    @Override
    public void handleBulletHit(TileEntity entity, Bullet bullet) {
        super.handleBulletHit(entity, bullet);
        if (bullet.damage() > this.maxDamageDeflect || bullet.isDeflected()) {
            return;
        }
        float penX = Math.abs(entity.x - bullet.x);
        float penY = Math.abs(entity.y - bullet.y);
        bullet.hitbox(this.rect2);
        Vector2 position = Geometry.raycastRect(bullet.x - bullet.velocity().x * Time.delta(), bullet.y - bullet.velocity().y * Time.delta(), bullet.x + bullet.velocity().x * Time.delta(), bullet.y + bullet.velocity().y * Time.delta(), this.rect.setSize((float)(this.size * 8) + this.rect2.width * 2.0f + this.rect2.height * 2.0f).setCenter(entity.x, entity.y));
        if (position != null) {
            bullet.set(position.x, position.y);
        }
        if (penX > penY) {
            bullet.velocity().x *= -1.0f;
        } else {
            bullet.velocity().y *= -1.0f;
        }
        bullet.resetOwner(entity, entity.getTeam());
        bullet.scaleTime(1.0f);
        bullet.deflect();
        ((DeflectorEntity)entity).hit = 1.0f;
    }

    @Override
    public TileEntity newEntity() {
        return new DeflectorEntity();
    }

    public static class DeflectorEntity
    extends TileEntity {
        public float hit;
    }
}

