/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense;

import io.anuke.arc.Core;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.AbsorbTrait;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.type.BaseEntity;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.consumers.ConsumeLiquidFilter;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ForceProjector
extends Block {
    protected int timerUse;
    protected float phaseUseTime;
    protected float phaseRadiusBoost;
    protected float radius;
    protected float breakage;
    protected float cooldownNormal;
    protected float cooldownLiquid;
    protected float cooldownBrokenBase;
    protected float basePowerDraw;
    protected float powerDamage;
    protected TextureRegion topRegion;
    private static Tile paramTile;
    private static ForceProjector paramBlock;
    private static ForceEntity paramEntity;
    private static Consumer<AbsorbTrait> shieldConsumer;

    public ForceProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.phaseUseTime = 350.0f;
        this.phaseRadiusBoost = 80.0f;
        this.radius = 101.7f;
        this.breakage = 550.0f;
        this.cooldownNormal = 1.75f;
        this.cooldownLiquid = 1.5f;
        this.cooldownBrokenBase = 0.35f;
        this.basePowerDraw = 0.2f;
        this.powerDamage = 0.1f;
        this.update = true;
        this.solid = true;
        this.hasPower = true;
        this.canOverdrive = false;
        this.hasLiquids = true;
        this.hasItems = true;
        this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.1f)).boost().update(false);
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.powerUse, this.basePowerDraw * 60.0f, StatUnit.powerSecond);
        this.stats.add(BlockStat.powerDamage, this.powerDamage, StatUnit.powerUnits);
        this.stats.add(BlockStat.boostEffect, this.phaseRadiusBoost / 8.0f, StatUnit.blocks);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Draw.color(Pal.accent);
        Lines.stroke(1.0f);
        Lines.poly(x * 8, (float)(y * 8), 6, this.radius);
        Draw.color();
    }

    @Override
    public void update(Tile tile) {
        ForceEntity entity = (ForceEntity)tile.entity();
        if (entity.shield == null) {
            entity.shield = new ShieldEntity(tile);
            entity.shield.add();
        }
        boolean phaseValid = ((Consume)this.consumes.get(ConsumeType.item)).valid(tile.entity);
        entity.phaseHeat = Mathf.lerpDelta(entity.phaseHeat, Mathf.num(phaseValid), 0.1f);
        if (phaseValid && !entity.broken && entity.timer.get(this.timerUse, this.phaseUseTime)) {
            entity.cons.trigger();
        }
        entity.radscl = Mathf.lerpDelta(entity.radscl, entity.broken ? 0.0f : entity.warmup, 0.05f);
        if (Mathf.chance(Time.delta() * entity.buildup / this.breakage * 0.1f)) {
            Effects.effect(Fx.reactorsmoke, tile.drawx() + Mathf.range(4.0f), tile.drawy() + Mathf.range(4.0f));
        }
        entity.warmup = Mathf.lerpDelta(entity.warmup, entity.power.satisfaction, 0.1f);
        if (entity.buildup > 0.0f) {
            float scale = !entity.broken ? this.cooldownNormal : this.cooldownBrokenBase;
            ConsumeLiquidFilter cons = (ConsumeLiquidFilter)this.consumes.get(ConsumeType.liquid);
            if (cons.valid(entity)) {
                cons.update(entity);
                scale *= this.cooldownLiquid * (1.0f + (entity.liquids.current().heatCapacity - 0.4f) * 0.9f);
            }
            entity.buildup -= Time.delta() * scale;
        }
        if (entity.broken && entity.buildup <= 0.0f) {
            entity.broken = false;
        }
        if (entity.buildup >= this.breakage && !entity.broken) {
            entity.broken = true;
            entity.buildup = this.breakage;
            Effects.effect(Fx.shieldBreak, tile.drawx(), tile.drawy(), this.radius);
        }
        if (entity.hit > 0.0f) {
            entity.hit -= 0.2f * Time.delta();
        }
        float realRadius = this.realRadius(entity);
        paramTile = tile;
        paramEntity = entity;
        paramBlock = this;
        Vars.bulletGroup.intersect(tile.drawx() - realRadius, tile.drawy() - realRadius, realRadius * 2.0f, realRadius * 2.0f, shieldConsumer);
    }

    float realRadius(ForceEntity entity) {
        return (this.radius + entity.phaseHeat * this.phaseRadiusBoost) * entity.radscl;
    }

    boolean isInsideHexagon(float x0, float y0, float d, float x, float y) {
        float a;
        float dx = Math.abs(x - x0) / d;
        float dy = Math.abs(y - y0) / d;
        return dy <= (a = 0.25f * Mathf.sqrt3) && (double)(a * dx) + 0.25 * (double)dy <= 0.5 * (double)a;
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        ForceEntity entity = (ForceEntity)tile.entity();
        if (entity.buildup <= 0.0f) {
            return;
        }
        Draw.alpha(entity.buildup / this.breakage * 0.75f);
        Draw.blend(Blending.additive);
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
        Draw.blend();
        Draw.reset();
    }

    @Override
    public TileEntity newEntity() {
        return new ForceEntity();
    }

    static {
        shieldConsumer = trait -> {
            if (trait.canBeAbsorbed() && trait.getTeam() != paramTile.getTeam() && paramBlock.isInsideHexagon(trait.getX(), trait.getY(), paramBlock.realRadius(paramEntity) * 2.0f, paramTile.drawx(), paramTile.drawy())) {
                trait.absorb();
                Effects.effect(Fx.absorb, trait);
                ForceProjector.paramEntity.hit = 1.0f;
                ForceProjector.paramEntity.buildup += trait.getShieldDamage() * ForceProjector.paramEntity.warmup;
            }
        };
    }

    public class ShieldEntity
    extends BaseEntity
    implements DrawTrait {
        final ForceEntity entity;

        public ShieldEntity(Tile tile) {
            this.entity = (ForceEntity)tile.entity();
            this.set(tile.drawx(), tile.drawy());
        }

        @Override
        public void update() {
            if (this.entity.isDead() || !this.entity.isAdded()) {
                this.remove();
            }
        }

        @Override
        public float drawSize() {
            return ForceProjector.this.realRadius(this.entity) * 2.0f + 2.0f;
        }

        @Override
        public void draw() {
            Draw.color(Pal.accent);
            Fill.poly(this.x, this.y, 6, ForceProjector.this.realRadius(this.entity));
            Draw.color();
        }

        public void drawOver() {
            if (this.entity.hit <= 0.0f) {
                return;
            }
            Draw.color(Color.white);
            Draw.alpha(this.entity.hit);
            Fill.poly(this.x, this.y, 6, ForceProjector.this.realRadius(this.entity));
            Draw.color();
        }

        public void drawSimple() {
            if (ForceProjector.this.realRadius(this.entity) < 0.5f) {
                return;
            }
            float rad = ForceProjector.this.realRadius(this.entity);
            Draw.color(Pal.accent);
            Lines.stroke(1.5f);
            Draw.alpha(0.09f + 0.08f * this.entity.hit);
            Fill.poly(this.x, this.y, 6, rad);
            Draw.alpha(1.0f);
            Lines.poly(this.x, this.y, 6, rad);
            Draw.reset();
        }

        @Override
        public EntityGroup targetGroup() {
            return Vars.shieldGroup;
        }
    }

    class ForceEntity
    extends TileEntity {
        ShieldEntity shield;
        boolean broken = true;
        float buildup = 0.0f;
        float radscl = 0.0f;
        float hit;
        float warmup;
        float phaseHeat;

        ForceEntity() {
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeBoolean(this.broken);
            stream.writeFloat(this.buildup);
            stream.writeFloat(this.radscl);
            stream.writeFloat(this.warmup);
            stream.writeFloat(this.phaseHeat);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.broken = stream.readBoolean();
            this.buildup = stream.readFloat();
            this.radscl = stream.readFloat();
            this.warmup = stream.readFloat();
            this.phaseHeat = stream.readFloat();
        }
    }
}

