/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense;

import io.anuke.arc.Core;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OverdriveProjector
extends Block {
    private static Color color = Color.valueOf("feb380");
    private static Color phase = Color.valueOf("ffd59e");
    private static IntSet healed = new IntSet();
    protected int timerUse;
    protected TextureRegion topRegion;
    protected float reload;
    protected float range;
    protected float speedBoost;
    protected float speedBoostPhase;
    protected float useTime;
    protected float phaseRangeBoost;

    public OverdriveProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.reload = 60.0f;
        this.range = 80.0f;
        this.speedBoost = 1.5f;
        this.speedBoostPhase = 0.75f;
        this.useTime = 400.0f;
        this.phaseRangeBoost = 20.0f;
        this.solid = true;
        this.update = true;
        this.hasPower = true;
        this.hasItems = true;
        this.canOverdrive = false;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Drawf.dashCircle((float)(x * 8) + this.offset(), (float)(y * 8) + this.offset(), this.range, Pal.accent);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.speedIncrease, (int)(100.0f * this.speedBoost), StatUnit.percent);
        this.stats.add(BlockStat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(BlockStat.boostEffect, this.phaseRangeBoost / 8.0f, StatUnit.blocks);
        this.stats.add(BlockStat.boostEffect, (int)((this.speedBoost + this.speedBoostPhase) * 100.0f), StatUnit.percent);
    }

    @Override
    public void update(Tile tile) {
        OverdriveEntity entity = (OverdriveEntity)tile.entity();
        entity.heat = Mathf.lerpDelta(entity.heat, entity.cons.valid() ? 1.0f : 0.0f, 0.08f);
        entity.charge += entity.heat * Time.delta();
        entity.phaseHeat = Mathf.lerpDelta(entity.phaseHeat, Mathf.num(entity.cons.optionalValid()), 0.1f);
        if (entity.timer.get(this.timerUse, this.useTime) && entity.power.satisfaction > 0.0f) {
            entity.cons.trigger();
        }
        if (entity.charge >= this.reload) {
            float realRange = this.range + entity.phaseHeat * this.phaseRangeBoost;
            float realBoost = (this.speedBoost + entity.phaseHeat * this.speedBoostPhase) * entity.power.satisfaction;
            entity.charge = 0.0f;
            int tileRange = (int)(realRange / 8.0f + 1.0f);
            healed.clear();
            for (int x = -tileRange + tile.x; x <= tileRange + tile.x; ++x) {
                for (int y = -tileRange + tile.y; y <= tileRange + tile.y; ++y) {
                    Tile other;
                    if (!Mathf.within(x * 8, y * 8, tile.drawx(), tile.drawy(), realRange) || (other = Vars.world.ltile(x, y)) == null || other.getTeamID() != tile.getTeamID() || healed.contains(other.pos()) || other.entity == null) continue;
                    if (other.entity.timeScale <= realBoost) {
                        other.entity.timeScaleDuration = Math.max(other.entity.timeScaleDuration, this.reload + 1.0f);
                        other.entity.timeScale = Math.max(other.entity.timeScale, realBoost);
                    }
                    healed.add(other.pos());
                }
            }
        }
    }

    @Override
    public void drawSelect(Tile tile) {
        OverdriveEntity entity = (OverdriveEntity)tile.entity();
        float realRange = this.range + entity.phaseHeat * this.phaseRangeBoost;
        Drawf.dashCircle(tile.drawx(), tile.drawy(), realRange, color);
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        OverdriveEntity entity = (OverdriveEntity)tile.entity();
        float f = 1.0f - Time.time() / 100.0f % 1.0f;
        Draw.color(color, phase, entity.phaseHeat);
        Draw.alpha(entity.heat * Mathf.absin(Time.time(), 10.0f, 1.0f) * 0.5f);
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
        Draw.alpha(1.0f);
        Lines.stroke((2.0f * f + 0.2f) * entity.heat);
        Lines.square(tile.drawx(), tile.drawy(), (1.0f - f) * 8.0f);
        Draw.reset();
    }

    @Override
    public TileEntity newEntity() {
        return new OverdriveEntity();
    }

    class OverdriveEntity
    extends TileEntity {
        float heat;
        float charge;
        float phaseHeat;

        OverdriveEntity() {
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.heat);
            stream.writeFloat(this.phaseHeat);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.heat = stream.readFloat();
            this.phaseHeat = stream.readFloat();
        }
    }
}

