/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.blocks.defense.Wall;

public class SurgeWall
extends Wall {
    protected float lightningChance = 0.05f;
    protected float lightningDamage = 15.0f;
    protected int lightningLength = 17;

    public SurgeWall(String name) {
        super(name);
    }

    @Override
    public void handleBulletHit(TileEntity entity, Bullet bullet) {
        super.handleBulletHit(entity, bullet);
        if (Mathf.chance(this.lightningChance)) {
            Lightning.create(entity.getTeam(), Pal.surge, this.lightningDamage, bullet.x, bullet.y, bullet.rot() + 180.0f, this.lightningLength);
        }
    }
}

