/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.ItemTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;

public class BurstTurret
extends ItemTurret {
    protected float burstSpacing = 5.0f;

    public BurstTurret(String name) {
        super(name);
    }

    @Override
    protected void shoot(Tile tile, BulletType ammo) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        entity.heat = 1.0f;
        for (int i = 0; i < this.shots; ++i) {
            Time.run(this.burstSpacing * (float)i, () -> {
                if (!(tile.entity instanceof Turret.TurretEntity) || !this.hasAmmo(tile)) {
                    return;
                }
                entity.recoil = this.recoil;
                this.tr.trns(entity.rotation, this.size * 8 / 2, Mathf.range(this.xRand));
                this.bullet(tile, ammo, entity.rotation + Mathf.range(this.inaccuracy));
                this.effects(tile);
                this.useAmmo(tile);
            });
        }
    }
}

