/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.PowerTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;

public class ChargeTurret
extends PowerTurret {
    protected float chargeTime = 30.0f;
    protected int chargeEffects = 5;
    protected float chargeMaxDelay = 10.0f;
    protected Effects.Effect chargeEffect = Fx.none;
    protected Effects.Effect chargeBeginEffect = Fx.none;

    public ChargeTurret(String name) {
        super(name);
    }

    @Override
    public void shoot(Tile tile, BulletType ammo) {
        LaserTurretEntity entity = (LaserTurretEntity)tile.entity();
        this.useAmmo(tile);
        this.tr.trns(entity.rotation, this.size * 8 / 2);
        Effects.effect(this.chargeBeginEffect, tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, entity.rotation);
        for (int i = 0; i < this.chargeEffects; ++i) {
            Time.run(Mathf.random(this.chargeMaxDelay), () -> {
                if (!this.isTurret(tile)) {
                    return;
                }
                this.tr.trns(entity.rotation, this.size * 8 / 2);
                Effects.effect(this.chargeEffect, tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, entity.rotation);
            });
        }
        entity.shooting = true;
        Time.run(this.chargeTime, () -> {
            if (!this.isTurret(tile)) {
                return;
            }
            this.tr.trns(entity.rotation, this.size * 8 / 2);
            entity.recoil = this.recoil;
            entity.heat = 1.0f;
            this.bullet(tile, ammo, entity.rotation + Mathf.range(this.inaccuracy));
            this.effects(tile);
            entity.shooting = false;
        });
    }

    @Override
    public boolean shouldTurn(Tile tile) {
        LaserTurretEntity entity = (LaserTurretEntity)tile.entity();
        return !entity.shooting;
    }

    @Override
    public TileEntity newEntity() {
        return new LaserTurretEntity();
    }

    public class LaserTurretEntity
    extends Turret.TurretEntity {
        public boolean shooting;
    }
}

