/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.OrderedMap;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.effect.Fire;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;
import io.anuke.mindustry.world.consumers.ConsumeLiquidFilter;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BlockStats;
import io.anuke.mindustry.world.meta.values.AmmoListValue;

public abstract class LiquidTurret
extends Turret {
    protected ObjectMap<Liquid, BulletType> ammo = new ObjectMap();

    public LiquidTurret(String name) {
        super(name);
        this.hasLiquids = true;
        this.activeSound = Sounds.spray;
    }

    protected void ammo(Object ... objects) {
        this.ammo = OrderedMap.of(objects);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.ammo, new AmmoListValue<Liquid>(this.ammo));
        this.consumes.add(new ConsumeLiquidFilter(i -> this.ammo.containsKey((Liquid)i), 1.0f){

            @Override
            public boolean valid(TileEntity entity) {
                return !((Turret.TurretEntity)entity).ammo.isEmpty();
            }

            @Override
            public void display(BlockStats stats) {
            }
        });
    }

    @Override
    public boolean shouldActiveSound(Tile tile) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        return entity.target != null && this.hasAmmo(tile);
    }

    @Override
    protected boolean validateTarget(Tile tile) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        if (entity.liquids.current().canExtinguish() && entity.target instanceof Tile) {
            return Fire.has(((Tile)entity.target).x, ((Tile)entity.target).y);
        }
        return super.validateTarget(tile);
    }

    @Override
    protected void findTarget(Tile tile) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        if (entity.liquids.current().canExtinguish()) {
            int tr = (int)(this.range / 8.0f);
            for (int x = -tr; x <= tr; ++x) {
                for (int y = -tr; y <= tr; ++y) {
                    if (!Fire.has(x + tile.x, y + tile.y)) continue;
                    entity.target = Vars.world.tile(x + tile.x, y + tile.y);
                    return;
                }
            }
        }
        super.findTarget(tile);
    }

    @Override
    protected void effects(Tile tile) {
        BulletType type = this.peekAmmo(tile);
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        Effects.effect(type.shootEffect, entity.liquids.current().color, tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, entity.rotation);
        Effects.effect(type.smokeEffect, entity.liquids.current().color, tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, entity.rotation);
        if (this.shootShake > 0.0f) {
            Effects.shake(this.shootShake, this.shootShake, tile.entity);
        }
        entity.recoil = this.recoil;
    }

    @Override
    public BulletType useAmmo(Tile tile) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        if (tile.isEnemyCheat()) {
            return this.ammo.get(entity.liquids.current());
        }
        BulletType type = this.ammo.get(entity.liquids.current());
        entity.liquids.remove(entity.liquids.current(), type.ammoMultiplier);
        return type;
    }

    @Override
    public BulletType peekAmmo(Tile tile) {
        return this.ammo.get(tile.entity.liquids.current());
    }

    @Override
    public boolean hasAmmo(Tile tile) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        return this.ammo.get(entity.liquids.current()) != null && entity.liquids.total() >= this.ammo.get((Liquid)entity.liquids.current()).ammoMultiplier;
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return false;
    }

    @Override
    public boolean acceptLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        return this.ammo.get(liquid) != null && (tile.entity.liquids.current() == liquid || this.ammo.containsKey(tile.entity.liquids.current()) && tile.entity.liquids.get(tile.entity.liquids.current()) <= this.ammo.get((Liquid)tile.entity.liquids.current()).ammoMultiplier + 0.001f);
    }
}

