/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.Core;
import io.anuke.arc.audio.Sound;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.function.BiConsumer;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Predict;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockFlag;
import io.anuke.mindustry.world.meta.BlockGroup;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public abstract class Turret
extends Block {
    protected static final int targetInterval = 20;
    protected final int timerTarget;
    protected Color heatColor;
    protected Effects.Effect shootEffect;
    protected Effects.Effect smokeEffect;
    protected Effects.Effect ammoUseEffect;
    protected Sound shootSound;
    protected int ammoPerShot;
    protected float ammoEjectBack;
    protected float range;
    protected float reload;
    protected float inaccuracy;
    protected int shots;
    protected float spread;
    protected float recoil;
    protected float restitution;
    protected float cooldown;
    protected float rotatespeed;
    protected float shootCone;
    protected float shootShake;
    protected float xRand;
    protected boolean targetAir;
    protected boolean targetGround;
    protected Vector2 tr;
    protected Vector2 tr2;
    protected TextureRegion baseRegion;
    protected TextureRegion heatRegion;
    protected BiConsumer<Tile, TurretEntity> drawer;
    protected BiConsumer<Tile, TurretEntity> heatDrawer;

    public Turret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.heatColor = Pal.turretHeat;
        this.shootEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.ammoUseEffect = Fx.none;
        this.shootSound = Sounds.shoot;
        this.ammoPerShot = 1;
        this.ammoEjectBack = 1.0f;
        this.range = 50.0f;
        this.reload = 10.0f;
        this.inaccuracy = 0.0f;
        this.shots = 1;
        this.spread = 4.0f;
        this.recoil = 1.0f;
        this.restitution = 0.02f;
        this.cooldown = 0.02f;
        this.rotatespeed = 5.0f;
        this.shootCone = 8.0f;
        this.shootShake = 0.0f;
        this.xRand = 0.0f;
        this.targetAir = true;
        this.targetGround = true;
        this.tr = new Vector2();
        this.tr2 = new Vector2();
        this.drawer = (tile, entity) -> Draw.rect(this.region, tile.drawx() + this.tr2.x, tile.drawy() + this.tr2.y, entity.rotation - 90.0f);
        this.heatDrawer = (tile, entity) -> {
            if (entity.heat <= 1.0E-5f) {
                return;
            }
            Draw.color(this.heatColor, entity.heat);
            Draw.blend(Blending.additive);
            Draw.rect(this.heatRegion, tile.drawx() + this.tr2.x, tile.drawy() + this.tr2.y, entity.rotation - 90.0f);
            Draw.blend();
            Draw.color();
        };
        this.update = true;
        this.solid = true;
        this.layer = Layer.turret;
        this.group = BlockGroup.turrets;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret});
        this.outlineIcon = true;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void load() {
        super.load();
        this.region = Core.atlas.find(this.name);
        this.baseRegion = Core.atlas.find("block-" + this.size);
        this.heatRegion = Core.atlas.find(this.name + "-heat");
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.shootRange, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(BlockStat.inaccuracy, (int)this.inaccuracy, StatUnit.degrees);
        this.stats.add(BlockStat.reload, 60.0f / this.reload, StatUnit.none);
        this.stats.add(BlockStat.shots, this.shots, StatUnit.none);
        this.stats.add(BlockStat.targetsAir, this.targetAir);
        this.stats.add(BlockStat.targetsGround, this.targetGround);
    }

    @Override
    public void draw(Tile tile) {
        Draw.rect(this.baseRegion, tile.drawx(), tile.drawy());
        Draw.color();
    }

    @Override
    public void drawLayer(Tile tile) {
        TurretEntity entity = (TurretEntity)tile.entity();
        this.tr2.trns(entity.rotation, -entity.recoil);
        this.drawer.accept(tile, entity);
        if (this.heatRegion != Core.atlas.find("error")) {
            this.heatDrawer.accept(tile, entity);
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find("block-" + this.size), Core.atlas.find(this.name)};
    }

    @Override
    public void drawSelect(Tile tile) {
        Drawf.dashCircle(tile.drawx(), tile.drawy(), this.range, tile.getTeam().color);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Drawf.dashCircle((float)(x * 8) + this.offset(), (float)(y * 8) + this.offset(), this.range, Pal.placing);
    }

    @Override
    public void update(Tile tile) {
        TurretEntity entity = (TurretEntity)tile.entity();
        if (!this.validateTarget(tile)) {
            entity.target = null;
        }
        entity.recoil = Mathf.lerpDelta(entity.recoil, 0.0f, this.restitution);
        entity.heat = Mathf.lerpDelta(entity.heat, 0.0f, this.cooldown);
        if (this.hasAmmo(tile)) {
            if (entity.timer.get(this.timerTarget, 20.0f)) {
                this.findTarget(tile);
            }
            if (this.validateTarget(tile)) {
                Vector2 result;
                BulletType type = this.peekAmmo(tile);
                float speed = type.speed;
                if (speed < 0.1f) {
                    speed = 9999999.0f;
                }
                if ((result = Predict.intercept(entity, entity.target, speed)).isZero()) {
                    result.set(entity.target.getX(), entity.target.getY());
                }
                float targetRot = result.sub(tile.drawx(), tile.drawy()).angle();
                if (Float.isNaN(entity.rotation)) {
                    entity.rotation = 0.0f;
                }
                if (this.shouldTurn(tile)) {
                    this.turnToTarget(tile, targetRot);
                }
                if (Angles.angleDist(entity.rotation, targetRot) < this.shootCone) {
                    this.updateShooting(tile);
                }
            }
        }
    }

    protected boolean validateTarget(Tile tile) {
        TurretEntity entity = (TurretEntity)tile.entity();
        return !Units.invalidateTarget(entity.target, tile.getTeam(), tile.drawx(), tile.drawy());
    }

    protected void findTarget(Tile tile) {
        TurretEntity entity = (TurretEntity)tile.entity();
        entity.target = this.targetAir && !this.targetGround ? Units.closestEnemy(tile.getTeam(), tile.drawx(), tile.drawy(), this.range, e -> !e.isDead() && e.isFlying()) : Units.closestTarget(tile.getTeam(), tile.drawx(), tile.drawy(), this.range, e -> !(e.isDead() || e.isFlying() && !this.targetAir || !e.isFlying() && !this.targetGround));
    }

    protected void turnToTarget(Tile tile, float targetRot) {
        TurretEntity entity = (TurretEntity)tile.entity();
        entity.rotation = Angles.moveToward(entity.rotation, targetRot, this.rotatespeed * entity.delta() * this.baseReloadSpeed(tile));
    }

    public boolean shouldTurn(Tile tile) {
        return true;
    }

    public BulletType useAmmo(Tile tile) {
        if (tile.isEnemyCheat()) {
            return this.peekAmmo(tile);
        }
        TurretEntity entity = (TurretEntity)tile.entity();
        AmmoEntry entry = entity.ammo.peek();
        entry.amount -= this.ammoPerShot;
        if (entry.amount == 0) {
            entity.ammo.pop();
        }
        entity.totalAmmo -= this.ammoPerShot;
        Time.run(this.reload / 2.0f, () -> this.ejectEffects(tile));
        return entry.type();
    }

    public BulletType peekAmmo(Tile tile) {
        TurretEntity entity = (TurretEntity)tile.entity();
        return entity.ammo.peek().type();
    }

    public boolean hasAmmo(Tile tile) {
        TurretEntity entity = (TurretEntity)tile.entity();
        return entity.ammo.size > 0 && entity.ammo.peek().amount >= this.ammoPerShot;
    }

    protected void updateShooting(Tile tile) {
        TurretEntity entity = (TurretEntity)tile.entity();
        if (entity.reload >= this.reload) {
            BulletType type = this.peekAmmo(tile);
            this.shoot(tile, type);
            entity.reload = 0.0f;
        } else {
            entity.reload += tile.entity.delta() * this.peekAmmo((Tile)tile).reloadMultiplier * this.baseReloadSpeed(tile);
        }
    }

    protected void shoot(Tile tile, BulletType type) {
        TurretEntity entity = (TurretEntity)tile.entity();
        entity.recoil = this.recoil;
        entity.heat = 1.0f;
        this.tr.trns(entity.rotation, (float)(this.size * 8) / 2.0f, Mathf.range(this.xRand));
        for (int i = 0; i < this.shots; ++i) {
            this.bullet(tile, type, entity.rotation + Mathf.range(this.inaccuracy + type.inaccuracy) + (float)(i - this.shots / 2) * this.spread);
        }
        this.effects(tile);
        this.useAmmo(tile);
    }

    protected void bullet(Tile tile, BulletType type, float angle) {
        Bullet.create(type, tile.entity, tile.getTeam(), tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, angle);
    }

    protected void effects(Tile tile) {
        Effects.Effect shootEffect = this.shootEffect == Fx.none ? this.peekAmmo((Tile)tile).shootEffect : this.shootEffect;
        Effects.Effect smokeEffect = this.smokeEffect == Fx.none ? this.peekAmmo((Tile)tile).smokeEffect : this.smokeEffect;
        TurretEntity entity = (TurretEntity)tile.entity();
        Effects.effect(shootEffect, tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, entity.rotation);
        Effects.effect(smokeEffect, tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, entity.rotation);
        this.shootSound.at(tile, Mathf.random(0.9f, 1.1f));
        if (this.shootShake > 0.0f) {
            Effects.shake(this.shootShake, this.shootShake, tile.entity);
        }
        entity.recoil = this.recoil;
    }

    protected void ejectEffects(Tile tile) {
        if (!this.isTurret(tile)) {
            return;
        }
        TurretEntity entity = (TurretEntity)tile.entity();
        Effects.effect(this.ammoUseEffect, tile.drawx() - Angles.trnsx(entity.rotation, this.ammoEjectBack), tile.drawy() - Angles.trnsy(entity.rotation, this.ammoEjectBack), entity.rotation);
    }

    protected float baseReloadSpeed(Tile tile) {
        return 1.0f;
    }

    protected boolean isTurret(Tile tile) {
        return tile.entity instanceof TurretEntity;
    }

    @Override
    public TileEntity newEntity() {
        return new TurretEntity();
    }

    public static class TurretEntity
    extends TileEntity {
        public Array<AmmoEntry> ammo = new Array();
        public int totalAmmo;
        public float reload;
        public float rotation = 90.0f;
        public float recoil = 0.0f;
        public float heat;
        public int shots;
        public TargetTrait target;
    }

    public static abstract class AmmoEntry {
        public int amount;

        public abstract BulletType type();
    }
}

