/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Edges;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.distribution.Conveyor;

public class ArmoredConveyor
extends Conveyor {
    public ArmoredConveyor(String name) {
        super(name);
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return super.acceptItem(item, tile, source) && (source.block() instanceof Conveyor || Edges.getFacingEdge(source, tile).relativeTo(tile) == tile.rotation());
    }

    @Override
    protected boolean blends(Tile tile, int direction) {
        Tile other = tile.getNearby(Mathf.mod(tile.rotation() - direction, 4));
        if (other != null) {
            other = other.link();
        }
        return other != null && other.block().outputsItems() && (tile.getNearby(tile.rotation()) == other || !other.block().rotate && Edges.getFacingEdge(other, tile).relativeTo(tile) == tile.rotation() || other.block().rotate && other.getNearby(other.rotation()) == tile);
    }
}

