/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.ItemBuffer;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.distribution.ExtendingItemBridge;
import io.anuke.mindustry.world.blocks.distribution.ItemBridge;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BufferedItemBridge
extends ExtendingItemBridge {
    protected int timerAccept;
    protected float speed;
    protected int bufferCapacity;

    public BufferedItemBridge(String name) {
        super(name);
        this.timerAccept = this.timers++;
        this.speed = 40.0f;
        this.bufferCapacity = 50;
        this.hasPower = false;
        this.hasItems = true;
    }

    @Override
    public void updateTransport(Tile tile, Tile other) {
        BufferedItemBridgeEntity entity = (BufferedItemBridgeEntity)tile.entity();
        if (entity.buffer.accepts() && entity.items.total() > 0) {
            entity.buffer.accept(entity.items.take());
        }
        Item item = entity.buffer.poll();
        if (entity.timer.get(this.timerAccept, 4.0f) && item != null && other.block().acceptItem(item, other, tile)) {
            entity.cycleSpeed = Mathf.lerpDelta(entity.cycleSpeed, 4.0f, 0.05f);
            other.block().handleItem(item, other, tile);
            entity.buffer.remove();
        } else {
            entity.cycleSpeed = Mathf.lerpDelta(entity.cycleSpeed, 0.0f, 0.008f);
        }
    }

    @Override
    public TileEntity newEntity() {
        return new BufferedItemBridgeEntity();
    }

    class BufferedItemBridgeEntity
    extends ItemBridge.ItemBridgeEntity {
        ItemBuffer buffer;

        BufferedItemBridgeEntity() {
            this.buffer = new ItemBuffer(BufferedItemBridge.this.bufferCapacity, BufferedItemBridge.this.speed);
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            this.buffer.write(stream);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.buffer.read(stream);
        }
    }
}

