/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.LiquidBlock;
import io.anuke.mindustry.world.modules.LiquidModule;

public class Conduit
extends LiquidBlock {
    protected final int timerFlow;
    protected TextureRegion[] topRegions;
    protected TextureRegion[] botRegions;

    public Conduit(String name) {
        super(name);
        this.timerFlow = this.timers++;
        this.topRegions = new TextureRegion[7];
        this.botRegions = new TextureRegion[7];
        this.rotate = true;
        this.solid = false;
        this.floating = true;
    }

    @Override
    public void load() {
        super.load();
        this.liquidRegion = Core.atlas.find("conduit-liquid");
        for (int i = 0; i < this.topRegions.length; ++i) {
            this.topRegions[i] = Core.atlas.find(this.name + "-top-" + i);
            this.botRegions[i] = Core.atlas.find("conduit-bottom-" + i);
        }
    }

    @Override
    public void onProximityUpdate(Tile tile) {
        super.onProximityUpdate(tile);
        ConduitEntity entity = (ConduitEntity)tile.entity();
        entity.blendbits = 0;
        entity.blendrot = 0;
        if (this.blends(tile, 2) && this.blends(tile, 1) && this.blends(tile, 3)) {
            entity.blendbits = (byte)3;
        } else if (this.blends(tile, 1) && this.blends(tile, 3)) {
            entity.blendbits = (byte)6;
        } else if (this.blends(tile, 1) && this.blends(tile, 2)) {
            entity.blendbits = (byte)2;
        } else if (this.blends(tile, 3) && this.blends(tile, 2)) {
            entity.blendbits = (byte)4;
        } else if (this.blends(tile, 1)) {
            entity.blendbits = (byte)5;
        } else if (this.blends(tile, 3)) {
            entity.blendbits = 1;
        }
    }

    private boolean blends(Tile tile, int direction) {
        Tile other = tile.getNearby(Mathf.mod(tile.rotation() - direction, 4));
        if (other != null) {
            other = other.link();
        }
        return other != null && other.block().hasLiquids && other.block().outputsLiquid && (tile.getNearby(tile.rotation()) == other || !other.block().rotate || other.getNearby(other.rotation()) == tile);
    }

    @Override
    public void draw(Tile tile) {
        ConduitEntity entity = (ConduitEntity)tile.entity();
        LiquidModule mod = tile.entity.liquids;
        int rotation = tile.rotation() * 90;
        Draw.colorl(0.34f);
        Draw.rect(this.botRegions[entity.blendbits], tile.drawx(), tile.drawy(), (float)rotation);
        Draw.color(mod.current().color);
        Draw.alpha(entity.smoothLiquid);
        Draw.rect(this.botRegions[entity.blendbits], tile.drawx(), tile.drawy(), (float)rotation);
        Draw.color();
        Draw.rect(this.topRegions[entity.blendbits], tile.drawx(), tile.drawy(), (float)rotation);
    }

    @Override
    public void update(Tile tile) {
        ConduitEntity entity = (ConduitEntity)tile.entity();
        entity.smoothLiquid = Mathf.lerpDelta(entity.smoothLiquid, entity.liquids.total() / this.liquidCapacity, 0.05f);
        if (tile.entity.liquids.total() > 0.001f && tile.entity.timer.get(this.timerFlow, 1.0f)) {
            this.tryMoveLiquid(tile, tile.getNearby(tile.rotation()), true, tile.entity.liquids.current());
            entity.noSleep();
        } else {
            entity.sleep();
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find("conduit-bottom"), Core.atlas.find(this.name + "-top-0")};
    }

    @Override
    public boolean acceptLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        tile.entity.noSleep();
        return tile.entity.liquids.get(liquid) + amount < this.liquidCapacity && (tile.entity.liquids.current() == liquid || tile.entity.liquids.get(tile.entity.liquids.current()) < 0.2f) && (2 + source.relativeTo(tile.x, tile.y)) % 4 != tile.rotation();
    }

    @Override
    public TileEntity newEntity() {
        return new ConduitEntity();
    }

    public static class ConduitEntity
    extends TileEntity {
        public float smoothLiquid;
        byte blendbits;
        int blendrot;
    }
}

