/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.graphics.g2d.CapStyle;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.distribution.ItemBridge;

public class ExtendingItemBridge
extends ItemBridge {
    public ExtendingItemBridge(String name) {
        super(name);
        this.hasItems = true;
    }

    @Override
    public void drawLayer(Tile tile) {
        ItemBridge.ItemBridgeEntity entity = (ItemBridge.ItemBridgeEntity)tile.entity();
        Tile other = Vars.world.tile(entity.link);
        if (!this.linkValid(tile, other)) {
            return;
        }
        byte i = tile.absoluteRelativeTo(other.x, other.y);
        float ex = other.worldx() - tile.worldx() - (float)(Geometry.d4[i].x * 8) / 2.0f;
        float ey = other.worldy() - tile.worldy() - (float)(Geometry.d4[i].y * 8) / 2.0f;
        float uptime = Vars.state.isEditor() ? 1.0f : entity.uptime;
        Lines.stroke(8.0f);
        Lines.line(this.bridgeRegion, tile.worldx() + (float)(Geometry.d4[i].x * 8) / 2.0f, tile.worldy() + (float)(Geometry.d4[i].y * 8) / 2.0f, tile.worldx() + (ex *= uptime), tile.worldy() + (ey *= uptime), CapStyle.none, 0.0f);
        Draw.rect(this.endRegion, tile.drawx(), tile.drawy(), (float)(i * 90 + 90));
        Draw.rect(this.endRegion, tile.worldx() + ex + (float)(Geometry.d4[i].x * 8) / 2.0f, tile.worldy() + ey + (float)(Geometry.d4[i].y * 8) / 2.0f, (float)(i * 90 + 270));
        int dist = Math.max(Math.abs(other.x - tile.x), Math.abs(other.y - tile.y));
        int arrows = dist * 8 / 6 - 1;
        Draw.color();
        for (int a = 0; a < arrows; ++a) {
            Draw.alpha(Mathf.absin((float)a / (float)arrows - entity.time / 100.0f, 0.1f, 1.0f) * uptime);
            Draw.rect(this.arrowRegion, tile.worldx() + (float)Geometry.d4[i].x * (4.0f + (float)a * 6.0f + 2.0f) * uptime, tile.worldy() + (float)Geometry.d4[i].y * (4.0f + (float)a * 6.0f + 2.0f) * uptime, (float)i * 90.0f);
        }
        Draw.reset();
    }
}

