/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.logic;

import io.anuke.arc.Core;
import io.anuke.arc.Input;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.BitmapFont;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.GlyphLayout;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.ui.TextArea;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.net.ValidateException;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MessageBlock
extends Block {
    protected static int maxTextLength = 220;
    protected static int maxNewlines = 24;

    public MessageBlock(String name) {
        super(name);
        this.configurable = true;
        this.solid = true;
        this.destructible = true;
    }

    public static void setMessageBlockText(Player player, Tile tile, String text) {
        if (!Units.canInteract(player, tile)) {
            return;
        }
        if (Vars.net.server() && text.length() > maxTextLength) {
            throw new ValidateException(player, "Player has gone above text limit.");
        }
        if (!(tile.block() instanceof MessageBlock)) {
            return;
        }
        StringBuilder result = new StringBuilder(text.length());
        text = text.trim();
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                if (++count > maxNewlines) continue;
                result.append('\n');
                continue;
            }
            result.append(c);
        }
        MessageBlockEntity entity = (MessageBlockEntity)tile.entity();
        if (entity != null) {
            entity.message = result.toString();
            entity.lines = entity.message.split("\n");
        }
    }

    @Override
    public void drawSelect(Tile tile) {
        MessageBlockEntity entity = (MessageBlockEntity)tile.entity();
        BitmapFont font = Fonts.outline;
        GlyphLayout l = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.getData().setScale(0.25f / Scl.scl(1.0f));
        font.setUseIntegerPositions(false);
        String text = entity.message == null || entity.message.isEmpty() ? "[lightgray]" + Core.bundle.get("empty") : entity.message;
        l.setText(font, text, Color.white, 90.0f, 8, true);
        float offset = 1.0f;
        Draw.color(0.0f, 0.0f, 0.0f, 0.2f);
        Fill.rect(tile.drawx(), tile.drawy() - 4.0f - l.height / 2.0f - offset, l.width + offset * 2.0f, l.height + offset * 2.0f);
        Draw.color();
        font.setColor(Color.white);
        font.draw(text, tile.drawx() - l.width / 2.0f, tile.drawy() - 4.0f - offset, 90.0f, 8, true);
        font.setUseIntegerPositions(ints);
        font.getData().setScale(1.0f);
        Pools.free(l);
    }

    @Override
    public void buildTable(final Tile tile, Table table) {
        final MessageBlockEntity entity = (MessageBlockEntity)tile.entity();
        table.addImageButton(Icon.pencilSmall, () -> {
            if (Vars.mobile) {
                Core.input.getTextInput(new Input.TextInput(){
                    {
                        this.text = entity.message;
                        this.multiline = true;
                        this.maxLength = maxTextLength;
                        this.accepted = out -> Call.setMessageBlockText(Vars.player, tile, out);
                    }
                });
            } else {
                FloatingDialog dialog = new FloatingDialog("$editmessage");
                dialog.setFillParent(false);
                TextArea a = dialog.cont.add(new TextArea(entity.message.replace("\n", "\r"))).size(380.0f, 160.0f).get();
                a.setFilter((textField, c) -> {
                    if (c == '\n' || c == '\r') {
                        int count = 0;
                        for (int i = 0; i < textField.getText().length(); ++i) {
                            if (textField.getText().charAt(i) != '\n' && textField.getText().charAt(i) != '\r') continue;
                            ++count;
                        }
                        return count < maxNewlines;
                    }
                    return true;
                });
                a.setMaxLength(maxTextLength);
                dialog.buttons.addButton("$ok", () -> {
                    Call.setMessageBlockText(Vars.player, tile, a.getText());
                    dialog.hide();
                }).size(130.0f, 60.0f);
                dialog.update(() -> {
                    if (!entity.isValid()) {
                        dialog.hide();
                    }
                });
                dialog.show();
            }
            Vars.control.input.frag.config.hideConfig();
        }).size(40.0f);
    }

    @Override
    public void updateTableAlign(Tile tile, Table table) {
        Vector2 pos = Core.input.mouseScreen(tile.drawx(), tile.drawy() + (float)(tile.block().size * 8) / 2.0f + 1.0f);
        table.setPosition(pos.x, pos.y, 4);
    }

    @Override
    public TileEntity newEntity() {
        return new MessageBlockEntity();
    }

    public class MessageBlockEntity
    extends TileEntity {
        protected String message = "";
        protected String[] lines = new String[]{""};

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeUTF(this.message);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.message = stream.readUTF();
        }
    }
}

