/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.power;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.power.PowerGenerator;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ImpactReactor
extends PowerGenerator {
    protected int timerUse;
    protected int plasmas;
    protected float warmupSpeed;
    protected float itemDuration;
    protected int explosionRadius;
    protected int explosionDamage;
    protected Color plasma1;
    protected Color plasma2;
    protected int bottomRegion;
    protected int[] plasmaRegions;

    public ImpactReactor(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.plasmas = 4;
        this.warmupSpeed = 0.001f;
        this.itemDuration = 60.0f;
        this.explosionRadius = 50;
        this.explosionDamage = 2000;
        this.plasma1 = Color.valueOf("ffd06b");
        this.plasma2 = Color.valueOf("ff361b");
        this.hasPower = true;
        this.hasLiquids = true;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.consumesPower = true;
        this.outputsPower = true;
        this.bottomRegion = this.reg("-bottom");
        this.plasmaRegions = new int[this.plasmas];
        for (int i = 0; i < this.plasmas; ++i) {
            this.plasmaRegions[i] = this.reg("-plasma-" + i);
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("poweroutput", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", Strings.fixed(Math.max(entity.block.getPowerProduction(entity.tile) - this.consumes.getPower().usage, 0.0f) * 60.0f * entity.timeScale, 1)), () -> Pal.powerBar, () -> ((PowerGenerator.GeneratorEntity)entity).productionEfficiency));
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(BlockStat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    @Override
    public void update(Tile tile) {
        FusionReactorEntity entity = (FusionReactorEntity)tile.entity();
        if (entity.cons.valid() && entity.power.satisfaction >= 0.99f) {
            boolean prevOut = this.getPowerProduction(tile) <= this.consumes.getPower().requestedPower(entity);
            entity.warmup = Mathf.lerpDelta(entity.warmup, 1.0f, this.warmupSpeed);
            if (Mathf.isEqual(entity.warmup, 1.0f, 0.001f)) {
                entity.warmup = 1.0f;
            }
            if (!prevOut && this.getPowerProduction(tile) > this.consumes.getPower().requestedPower(entity)) {
                Events.fire(EventType.Trigger.impactPower);
            }
            if (entity.timer.get(this.timerUse, this.itemDuration / entity.timeScale)) {
                entity.cons.trigger();
            }
        } else {
            entity.warmup = Mathf.lerpDelta(entity.warmup, 0.0f, 0.01f);
        }
        entity.productionEfficiency = Mathf.pow(entity.warmup, 5.0f);
    }

    @Override
    public void draw(Tile tile) {
        FusionReactorEntity entity = (FusionReactorEntity)tile.entity();
        Draw.rect(this.reg(this.bottomRegion), tile.drawx(), tile.drawy());
        for (int i = 0; i < this.plasmas; ++i) {
            float r = 29.0f + Mathf.absin(Time.time(), 2.0f + (float)i * 1.0f, 5.0f - (float)i * 0.5f);
            Draw.color(this.plasma1, this.plasma2, (float)i / (float)this.plasmas);
            Draw.alpha((0.3f + Mathf.absin(Time.time(), 2.0f + (float)i * 2.0f, 0.3f + (float)i * 0.05f)) * entity.warmup);
            Draw.blend(Blending.additive);
            Draw.rect(this.reg(this.plasmaRegions[i]), tile.drawx(), tile.drawy(), r, r, Time.time() * (12.0f + (float)i * 6.0f) * entity.warmup);
            Draw.blend();
        }
        Draw.color();
        Draw.rect(this.region, tile.drawx(), tile.drawy());
        Draw.color();
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-bottom"), Core.atlas.find(this.name)};
    }

    @Override
    public TileEntity newEntity() {
        return new FusionReactorEntity();
    }

    @Override
    public void onDestroyed(Tile tile) {
        int i;
        super.onDestroyed(tile);
        FusionReactorEntity entity = (FusionReactorEntity)tile.entity();
        if (entity.warmup < 0.4f) {
            return;
        }
        Sounds.explosionbig.at(tile);
        Effects.shake(6.0f, 16.0f, tile.worldx(), tile.worldy());
        Effects.effect(Fx.impactShockwave, tile.worldx(), tile.worldy());
        for (i = 0; i < 6; ++i) {
            Time.run(Mathf.random(80), () -> Effects.effect(Fx.impactcloud, tile.worldx(), tile.worldy()));
        }
        Damage.damage(tile.worldx(), tile.worldy(), this.explosionRadius * 8, this.explosionDamage * 4);
        for (i = 0; i < 20; ++i) {
            Time.run(Mathf.random(80), () -> {
                Tmp.v1.rnd(Mathf.random(40.0f));
                Effects.effect(Fx.explosion, Tmp.v1.x + tile.worldx(), Tmp.v1.y + tile.worldy());
            });
        }
        for (i = 0; i < 70; ++i) {
            Time.run(Mathf.random(90), () -> {
                Tmp.v1.rnd(Mathf.random(120.0f));
                Effects.effect(Fx.impactsmoke, Tmp.v1.x + tile.worldx(), Tmp.v1.y + tile.worldy());
            });
        }
    }

    public static class FusionReactorEntity
    extends PowerGenerator.GeneratorEntity {
        public float warmup;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.warmup);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.warmup = stream.readFloat();
        }
    }
}

